/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.distribution;

import com.atlassian.distribution.MavenVersion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ExtraResources {
    private static final String[] MAVEN_ALIAS_SCRIPTS = new String[]{"mvn3.sh", "mvn3.bat"};

    public static void copyResources(File outputDirectory, ArtifactFactory artifactFactory, ArtifactResolver resolver, List remoteRepositories, ArtifactRepository localRepository, Set<MavenVersion> mavenVersions, Log log) throws MojoExecutionException {
        ExtraResources.copySettingsFiles(outputDirectory);
        for (MavenVersion mavenVersion : mavenVersions) {
            ExtraResources.downloadMaven(artifactFactory, resolver, remoteRepositories, localRepository, outputDirectory, mavenVersion.getVersionString(), "maven3", log);
        }
        ExtraResources.copyMavenAliasScripts(outputDirectory, mavenVersions);
    }

    private static void copySettingsFiles(File outputDirectory) throws MojoExecutionException {
        try {
            InputStream settingsFileStream = ExtraResources.class.getResourceAsStream("/settings.xml");
            File settingsFile = new File(outputDirectory, "settings.xml");
            FileWriter settingsWriter = new FileWriter(settingsFile);
            IOUtils.copy((InputStream)settingsFileStream, (Writer)settingsWriter);
            settingsFileStream.close();
            settingsWriter.flush();
            settingsWriter.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write settings.xml ", (Exception)e);
        }
    }

    private static void downloadMaven(ArtifactFactory artifactFactory, ArtifactResolver resolver, List remoteRepositories, ArtifactRepository localRepository, File checkoutDirectory, String mavenVersion, String mavenDirectoryName, Log log) throws MojoExecutionException {
        Artifact mavenArtifact = artifactFactory.createArtifactWithClassifier("org.apache.maven", "apache-maven", mavenVersion, "zip", "bin");
        try {
            resolver.resolve(mavenArtifact, remoteRepositories, localRepository);
            File mavenBinary = mavenArtifact.getFile();
            File mavenDir = new File(checkoutDirectory, mavenDirectoryName);
            if (mavenDir.exists() && mavenDir.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)new File(mavenDir, "apache-maven-" + mavenVersion));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to delete existing maven dir: " + mavenDir.getAbsolutePath(), (Exception)e);
                }
            }
            mavenDir.mkdirs();
            ZipHelper zipHelper = new ZipHelper(log);
            zipHelper.unzipArchive(mavenBinary, mavenDir, true);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve maven binary artifact: ", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Failed to find maven binary artifact: ", (Exception)((Object)e));
        }
    }

    private static void copyMavenAliasScripts(File checkoutDirectory, Set<MavenVersion> mavenVersions) throws MojoExecutionException {
        try {
            for (MavenVersion mavenVersion : mavenVersions) {
                for (String scriptName : MAVEN_ALIAS_SCRIPTS) {
                    InputStream scriptInputStream = ExtraResources.class.getResourceAsStream("/" + scriptName);
                    File scriptFile = new File(checkoutDirectory, mavenVersion.getMavenRunnerCmd() + scriptName.substring(scriptName.lastIndexOf(".")));
                    FileWriter scriptWriter = new FileWriter(scriptFile);
                    String scriptContent = IOUtils.toString((InputStream)scriptInputStream);
                    String updatedScript = scriptContent.replaceAll("\\{mavenVersion\\}", mavenVersion.getVersionString());
                    IOUtils.write((String)updatedScript, (Writer)scriptWriter);
                    scriptFile.setExecutable(true, false);
                    scriptInputStream.close();
                    scriptWriter.flush();
                    scriptWriter.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't write mvn alias scripts: ", (Exception)e);
        }
    }

    public static class ZipHelper {
        Log log;

        public ZipHelper(Log log) {
            this.log = log;
        }

        public void unzipArchive(File archive, File outputDir, boolean makeFilesExecutable) {
            try {
                ZipFile zipfile = new ZipFile(archive);
                Enumeration<? extends ZipEntry> e = zipfile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    this.unzipEntry(zipfile, entry, outputDir, makeFilesExecutable);
                }
            }
            catch (Exception e) {
                this.log.error((CharSequence)("Error while extracting file " + archive), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir, boolean makeFilesExecutable) throws IOException {
            if (entry.isDirectory()) {
                this.createDir(new File(outputDir, entry.getName()));
                return;
            }
            File outputFile = new File(outputDir, entry.getName());
            if (!outputFile.getParentFile().exists()) {
                this.createDir(outputFile.getParentFile());
            }
            this.log.debug((CharSequence)("Extracting: " + entry));
            BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                if (makeFilesExecutable) {
                    outputFile.setExecutable(true, false);
                }
            }
            finally {
                outputStream.close();
                inputStream.close();
            }
        }

        private void createDir(File dir) {
            this.log.debug((CharSequence)("Creating dir " + dir.getName()));
            if (!dir.mkdirs()) {
                throw new RuntimeException("Can not create dir " + dir);
            }
        }
    }
}

