/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.msgraph.util;

import io.atlassian.fugue.Either;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class LazyLinkedListExecutor<T>
implements Iterable<T> {
    public final T value;
    public final boolean hasNext;
    private final Supplier<Either<Throwable, LazyLinkedListExecutor<T>>> getNext;

    public LazyLinkedListExecutor(T value) {
        this.value = value;
        this.hasNext = false;
        this.getNext = this::next;
    }

    public LazyLinkedListExecutor(T value, Supplier<Either<Throwable, LazyLinkedListExecutor<T>>> getNext) {
        this.value = value;
        this.hasNext = true;
        this.getNext = getNext;
    }

    public Either<Throwable, LazyLinkedListExecutor<T>> next() {
        return this.hasNext ? this.getNext.get() : Either.left((Object)new NoItemsAvailable());
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return Iterables.unfold(maybeItem -> maybeItem.flatMap(item -> {
            if (item.hasNext) {
                Either next = item.next();
                return next.toOption().map(nextItem -> Pair.pair(item.value, (Object)Option.some((Object)nextItem)));
            }
            return Option.some((Object)Pair.pair(item.value, (Object)Option.none()));
        }), (Object)Option.some((Object)this)).iterator();
    }

    public Either<Throwable, T> reduce(BinaryOperator<T> combine) {
        if (this.hasNext) {
            return this.next().flatMap(next -> next.reduce(combine)).map(ts -> combine.apply(this.value, ts));
        }
        return Either.right(this.value);
    }

    public static <T> LazyLinkedListExecutor<T> fromList(T first, List<T> rest) {
        if (rest.isEmpty()) {
            return new LazyLinkedListExecutor<T>(first);
        }
        return new LazyLinkedListExecutor<T>(first, () -> Either.right(LazyLinkedListExecutor.fromList(rest.get(0), rest.subList(1, rest.size()))));
    }

    public static class NoItemsAvailable
    extends Throwable {
        public NoItemsAvailable() {
            super("Tried to request next when there were none left");
        }
    }
}

