/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.msgraph.service;

import com.atlassian.mail.msgraph.service.ExternalMailPuller;
import com.atlassian.mail.msgraph.service.MicrosoftGraphMailClient;
import com.atlassian.mail.msgraph.settings.providers.MailConnectionSettingsProvider;
import com.atlassian.mail.msgraph.util.LazyLinkedListExecutor;
import com.atlassian.mail.msgraph.util.Lists;
import com.google.common.annotations.VisibleForTesting;
import com.microsoft.graph.models.MailFolder;
import com.microsoft.graph.requests.MailFolderCollectionPage;
import com.microsoft.graph.requests.MessageCollectionPage;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.mail.Message;
import org.joda.time.DateTime;

public class MicrosoftGraphMailService
implements ExternalMailPuller {
    private final MailConnectionSettingsProvider settingsProvider;
    private final MicrosoftGraphMailClient microsoftGraphClient;

    public MicrosoftGraphMailService(MailConnectionSettingsProvider settingsProvider) {
        this.settingsProvider = settingsProvider;
        this.microsoftGraphClient = new MicrosoftGraphMailClient(settingsProvider);
    }

    @VisibleForTesting
    MicrosoftGraphMailService(MailConnectionSettingsProvider settingsProvider, MicrosoftGraphMailClient microsoftGraphMailClient) {
        this.settingsProvider = settingsProvider;
        this.microsoftGraphClient = microsoftGraphMailClient;
    }

    @Override
    public Either<Throwable, Unit> verifyConnection() {
        return this.microsoftGraphClient.getMessages(new DateTime(this.settingsProvider.getMailSettings().getPullFromDate()), "inbox").map(messagePage -> Unit.VALUE);
    }

    @Override
    public Either<Throwable, List<Message>> pullMessages() {
        Either<Throwable, String> folderIdByName = this.getFolderIdByName();
        if (folderIdByName.isLeft()) {
            return Either.left((Object)folderIdByName.left().get());
        }
        Either<Throwable, MessageCollectionPage> firstPage = this.microsoftGraphClient.getMessages(new DateTime(this.settingsProvider.getMailSettings().getPullFromDate()), (String)folderIdByName.right().get());
        Either allPages = firstPage.map(messagePage -> new LazyLinkedListExecutor(Collections.emptyList(), () -> this.pullMessagesPage(firstPage)));
        return allPages.flatMap(executor -> executor.reduce((xva$0, xva$1) -> Lists.concat(xva$0, xva$1)));
    }

    private Either<Throwable, LazyLinkedListExecutor<List<Message>>> pullMessagesPage(Either<Throwable, MessageCollectionPage> current) {
        return current.map(messagesPage -> {
            List<Message> messages = this.microsoftGraphClient.getMessageStubsFromMessagePage((MessageCollectionPage)messagesPage);
            if (messagesPage.getNextPage() == null) {
                return new LazyLinkedListExecutor<List<Message>>(messages);
            }
            return new LazyLinkedListExecutor<List<Message>>(messages, () -> this.pullMessagesPage(this.microsoftGraphClient.getNextMessagesPage((MessageCollectionPage)messagesPage)));
        });
    }

    private Either<Throwable, String> getFolderIdByName() {
        String folderName = this.settingsProvider.getMailSettings().getFolder();
        if (!folderName.equalsIgnoreCase("inbox")) {
            Either<Throwable, MailFolderCollectionPage> either = this.microsoftGraphClient.getFolderIdByName(folderName);
            if (either.isLeft()) {
                return Either.left((Object)either.left().get());
            }
            Optional<MailFolder> mailFolder = ((MailFolderCollectionPage)either.right().get()).getCurrentPage().stream().filter(f -> f.displayName != null && f.displayName.equals(this.settingsProvider.getMailSettings().getFolder())).findFirst();
            return mailFolder.map(folder -> Either.right((Object)folder.id)).orElseGet(() -> Either.left((Object)new IllegalArgumentException("Folder with name " + folderName + " cannot be found")));
        }
        return Either.right((Object)"inbox");
    }

    @Override
    public Either<Throwable, Unit> markMessageRead(Message message) {
        return this.microsoftGraphClient.markMessageRead(message);
    }
}

