package com.atlassian.lesscss.spi;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

/**
 * A object which can resolve the contents of a URI
 */
@TenantAware(TenancyScope.TENANTLESS) // With the exception of the `DynamicLookAndFeelUriResolver`.
public interface UriResolver {

    /**
     * @param uri the uri to test
     * @return {@code true} if the resolver can resolve the uri, {@code false} otherwise. {@link #supports(java.net.URI)} is implied.
     */
    boolean exists(URI uri);

    /**
     * @param uri the uri to test
     * @return a string representing the current state of the URI. A change in this state indicates a change in the
     *         rendering of the LESS file
     */
    String encodeState(URI uri);

    /**
     *
     * @param uri the uri to load
     * @throws IOException if the content cannot be written
     */
    InputStream open(URI uri) throws IOException;

    /**
     * @param uri the uri to test
     * @return {@code true} if the resolver supports the uri, {@code false} otherwise. This may be based on the scheme or any other requirement of the resolver
     */
    boolean supports(URI uri);

}
