package com.atlassian.lesscss.spi;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.Dimensions;

import java.net.URI;

/**
 * UriResolver that supports prebaking.
 */
@ExperimentalApi
public interface DimensionAwareUriResolver extends UriResolver {

    /**
     * @return the dimensions for the uri resolver
     */
    Dimensions computeDimensions();

    /**
     * @param uri the uri to test
     * @param coord the coordinate to be added to the state
     * @return a string representing the current state of the URI, and an option of a {@code PrebakeError}.
     *         A change in this state indicates a change in the rendering of the LESS file
     */
    EncodeStateResult encodeState(URI uri, Coordinate coord);
}
