/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RequiresLoginServlet
extends HttpServlet {
    public static final String RAB_ANONYMOUS = "rest.api.browser.anonymous";
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final UserManager userManager;

    protected RequiresLoginServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider) {
        this.loginUriProvider = Objects.requireNonNull(loginUriProvider, "loginUriProvider");
        this.renderer = Objects.requireNonNull(renderer, "renderer");
        this.userManager = Objects.requireNonNull(userManager, "userManager");
    }

    protected abstract String getTemplatePath();

    protected abstract Map<String, Object> getContext(HttpServletRequest var1);

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.loginRequired(req)) {
            this.redirectToLogin(req, resp);
        } else {
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(this.getTemplatePath(), this.getContext(req), (Writer)resp.getWriter());
        }
    }

    private boolean loginRequired(HttpServletRequest req) {
        return !Boolean.getBoolean(RAB_ANONYMOUS) && this.userManager.getRemoteUserKey(req) == null;
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(RequiresLoginServlet.getUri(request)).toASCIIString());
    }

    private static URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

