/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.provider;

import com.atlassian.confluence.plugin.descriptor.rpc.SoapModuleDescriptor;
import com.atlassian.labs.restbrowser.plugin.AbstractSoapService;
import com.atlassian.labs.restbrowser.plugin.SoapService;
import com.atlassian.labs.restbrowser.provider.SoapServiceProvider;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConfluenceSoapServiceProvider
implements SoapServiceProvider {
    private final PluginAccessor pluginAccessor;

    public ConfluenceSoapServiceProvider(PluginAccessor pluginAccessor) {
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
    }

    @Override
    public Iterable<? extends SoapService> getSoapServices() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(SoapModuleDescriptor.class).stream().map(x$0 -> ConfluenceSoapService.getInstance(x$0)).collect(Collectors.toList());
    }

    private static final class ConfluenceSoapService
    extends AbstractSoapService<SoapModuleDescriptor> {
        private static ConfluenceSoapService getInstance(SoapModuleDescriptor soapModuleDescriptor) {
            if (soapModuleDescriptor == null) {
                return null;
            }
            return new ConfluenceSoapService(soapModuleDescriptor);
        }

        private ConfluenceSoapService(SoapModuleDescriptor moduleDescriptor) {
            this.moduleDescriptor = (ModuleDescriptor)Objects.requireNonNull(moduleDescriptor);
        }

        @Override
        public String getServicePath() {
            return ((SoapModuleDescriptor)this.moduleDescriptor).getServicePath();
        }

        @Override
        public Class<?> getPublishedInterface() {
            try {
                return ((SoapModuleDescriptor)this.moduleDescriptor).getPublishedInterface();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Couldn't get published interface from Confluence SOAP module descriptor", e);
            }
        }
    }
}

