/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.utils;

import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionKit {
    private static final AtomicReference<BundleContext> bundleContext = new AtomicReference();

    @Autowired
    public VersionKit(BundleContext bundleCtx) {
        bundleContext.set(bundleCtx);
    }

    public static Version getVersion() {
        return VersionKit.bundleContext().getBundle().getVersion();
    }

    public static String getDisplayedVersion() {
        return VersionKit.getVersion().toString();
    }

    private static BundleContext bundleContext() {
        BundleContext context = bundleContext.get();
        if (context == null) {
            throw new IllegalStateException("VersionKit accessed before wiring");
        }
        return context;
    }
}

