/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.inspectors;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class EventInspector
implements LifecycledComponent {
    private final EventPublisher eventPublisher;
    private final BoundedList<Event> events = new BoundedList(200);

    @Inject
    public EventInspector(@ComponentImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void onStartup() {
        this.eventPublisher.register((Object)this);
    }

    @Override
    public void onShutdown() {
        this.eventPublisher.unregister((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onEvent(Object rawEvent) {
        Event event = new Event(System.currentTimeMillis(), rawEvent);
        EventInspector eventInspector = this;
        synchronized (eventInspector) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> getCurrentEvents() {
        ArrayList<Event> out;
        EventInspector eventInspector = this;
        synchronized (eventInspector) {
            out = new ArrayList<Event>(this.events);
        }
        Collections.reverse(out);
        return out;
    }

    public static class BoundedList<E>
    extends LinkedList<E> {
        private final int maxSize;

        public BoundedList(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public boolean add(E e) {
            if (this.size() >= this.maxSize) {
                this.removeFirst();
            }
            return super.add(e);
        }

        @Override
        public void addFirst(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(E e) {
            this.add(e);
        }
    }

    public static class Event {
        private final long when;
        private final Object event;

        Event(long when, Object event) {
            this.when = when;
            this.event = Objects.requireNonNull(event);
        }

        public Object getEvent() {
            return this.event;
        }

        public long getWhen() {
            return this.when;
        }
    }
}

