/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.config;

import com.atlassian.labs.plugins.quickreload.utils.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class PomConventionStrategy {
    private final File startDir;

    public PomConventionStrategy(File startDir) {
        this.startDir = startDir;
    }

    public List<File> getTargetDirs() {
        Optional<File> lastPomFile = Files.traverseUpForFileThenYouFindItAndTheCant("pom.xml", this.startDir);
        if (lastPomFile.isPresent()) {
            ArrayList<File> trackedDirs = new ArrayList<File>();
            File startDir = lastPomFile.get().getParentFile();
            Files.traverseDownLookingForFile("pom.xml", startDir, file -> {
                if (!Files.pathContainsDirectory(file, "target")) {
                    this.addTargetToList((List<File>)trackedDirs, (File)file);
                }
            });
            return trackedDirs;
        }
        return Collections.emptyList();
    }

    private void addTargetToList(List<File> trackedDirs, File file) {
        File target = Files.smooshNames(file.getParent(), "target");
        try {
            trackedDirs.add(target.getCanonicalFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

