/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.utils;

import java.util.concurrent.TimeUnit;

public class Timer {
    private static final Clock REAL_CLOCK = new Clock(){

        @Override
        public long currentMillis() {
            return System.currentTimeMillis();
        }
    };
    private final Clock clock;
    private long then;

    public Timer() {
        this(REAL_CLOCK);
    }

    Timer(Clock clock) {
        this.clock = clock;
        this.then = clock.currentMillis();
    }

    public long elapsedMillis() {
        return this.clock.currentMillis() - this.then;
    }

    public boolean hasElapsed(long duration, TimeUnit timeUnit) {
        long durationMS = timeUnit.toMillis(duration);
        return this.hasElapsed(durationMS);
    }

    public boolean hasElapsed(long durationMS) {
        long passedMS = this.elapsedMillis();
        return passedMS >= durationMS;
    }

    public boolean isInside(long durationMS) {
        return !this.hasElapsed(durationMS);
    }

    public boolean isInside(long duration, TimeUnit timeUnit) {
        long durationMS = timeUnit.toMillis(duration);
        return this.isInside(durationMS);
    }

    public void reset() {
        this.then = this.clock.currentMillis();
    }

    static interface Clock {
        public long currentMillis();
    }
}

