/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.labs.plugins.quickreload.StateManager;
import com.atlassian.labs.plugins.quickreload.rest.Links;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json", "text/plain", "application/x-www-form-urlencoded"})
@Path(value="/batching")
public class BatchingResource {
    private final StateManager stateManager;

    public BatchingResource(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    @GET
    public Response getBatchingState(@Context UriInfo uriInfo) {
        return this.ok(uriInfo);
    }

    @GET
    @Path(value="setState")
    public Response setBatchingState(@QueryParam(value="enabled") String enableFlag, @Context UriInfo uriInfo) {
        if (StringUtils.isNotEmpty((String)enableFlag)) {
            boolean enabled = Boolean.valueOf(enableFlag);
            if (enabled) {
                this.stateManager.enableBatching();
            } else {
                this.stateManager.disableBatching();
            }
        }
        return this.ok(uriInfo);
    }

    @PUT
    public Response batchingOn(@Context UriInfo uriInfo) {
        this.stateManager.enableBatching();
        return this.ok(uriInfo);
    }

    private Response ok(UriInfo uriInfo) {
        return Response.ok((Object)new Batching(this.api(uriInfo), this.stateManager.isBatchingEnabled())).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @DELETE
    public Response batchingOff(@Context UriInfo uriInfo) {
        this.stateManager.disableBatching();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)new Batching(this.api(uriInfo), this.stateManager.isBatchingEnabled())).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private Links.ApiLinks api(UriInfo uriInfo) {
        return Links.ApiLinks.builder(uriInfo).build();
    }

    static class Batching {
        public final boolean batchingEnabled;
        public final Links.ApiLinks api;

        public Batching(Links.ApiLinks api, boolean batchingEnabled) {
            this.api = api;
            this.batchingEnabled = batchingEnabled;
        }
    }
}

