/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.fugue.Option;
import com.atlassian.labs.plugins.quickreload.cache.WebResourceUrlFlusher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class StateManager {
    public static final String PLUGIN_WEBRESOURCE_BATCHING_OFF = "plugin.webresource.batching.off";
    public static final String ATLASSIAN_WEBRESOURCE_DISABLE_MINIFICATION = "atlassian.webresource.disable.minification";
    public static final String ATLASSIAN_DISABLE_CACHES = "atlassian.disable.caches";
    public static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    public static final String JIRA_DEV_MODE = "jira.dev.mode";
    public static final String JIRA_I18N_RELOAD_BUNDLES = "jira.i18n.reloadbundles";
    public static final String JIRA_SUPERBATCH_DISABLED = "jira.superbatching.disabled";
    public static final String CONFLUENCE_DEV_MODE = "confluence.devmode";
    public static final String CONFLUENCE_CONTEXT_BATCHING_OFF = "confluence.context.batching.disable";
    private static final List<BatchingSystemProperty> batchingModeSystemProperties = ImmutableList.builder().add((Object)new BatchingSystemProperty("plugin.webresource.batching.off", "false", "true")).add((Object)new BatchingSystemProperty("atlassian.webresource.disable.minification", "false", "true")).add((Object)new BatchingSystemProperty("atlassian.disable.caches", "false", "true")).add((Object)new BatchingSystemProperty("atlassian.dev.mode", "false", "true")).add((Object)new BatchingSystemProperty("jira.dev.mode", "false", "true")).add((Object)new BatchingSystemProperty("jira.i18n.reloadbundles", "false", "true")).add((Object)new BatchingSystemProperty("jira.superbatching.disabled", "false", "true")).add((Object)new BatchingSystemProperty("confluence.devmode", "false", "true")).add((Object)new BatchingSystemProperty("confluence.context.batching.disable", "false", "true")).build();
    private static final Logger log = LoggerFactory.getLogger(StateManager.class);
    private final WebResourceUrlFlusher resourceUrlFlusher;
    private volatile boolean quickReloadEnabled = true;

    @Autowired
    public StateManager(WebResourceUrlFlusher resourceUrlFlusher) {
        this.resourceUrlFlusher = resourceUrlFlusher;
    }

    public boolean isQuickReloadEnabled() {
        return this.quickReloadEnabled;
    }

    public void enableQuickReload() {
        this.quickReloadEnabled = true;
    }

    public void disableQuickReload() {
        this.quickReloadEnabled = false;
    }

    public boolean isBatchingEnabled() {
        String batchingOff = System.getProperty(PLUGIN_WEBRESOURCE_BATCHING_OFF);
        return Boolean.valueOf(batchingOff) == false;
    }

    public void enableBatching() {
        this.setProperties(true);
        this.resourceUrlFlusher.flushWebResourceUrls();
        log.info("Web resource batching is now ENABLED");
    }

    public void disableBatching() {
        this.setProperties(false);
        this.resourceUrlFlusher.flushWebResourceUrls();
        log.info("Web resource batching is now DISABLED");
    }

    private void setProperties(boolean batchingEnabled) {
        for (BatchingSystemProperty property : batchingModeSystemProperties) {
            if (batchingEnabled) {
                System.setProperty(property.key, property.valueForBatchingEnabled);
                continue;
            }
            System.setProperty(property.key, property.valueForBatchingDisabled);
        }
    }

    public Map<String, String> getBatchingSystemPropertyStates() {
        ImmutableMap.Builder systemPropertyStatesBuilder = ImmutableMap.builder();
        for (BatchingSystemProperty batchingSystemProperty : batchingModeSystemProperties) {
            String key = batchingSystemProperty.key;
            Option stateOpt = Option.option((Object)System.getProperty(key));
            for (String state : stateOpt) {
                systemPropertyStatesBuilder.put((Object)key, (Object)state);
            }
        }
        return systemPropertyStatesBuilder.build();
    }

    private static class BatchingSystemProperty {
        public final String key;
        public final String valueForBatchingEnabled;
        public final String valueForBatchingDisabled;

        public BatchingSystemProperty(String key, String valueForBatchingEnabled, String valueForBatchingDisabled) {
            this.key = key;
            this.valueForBatchingEnabled = valueForBatchingEnabled;
            this.valueForBatchingDisabled = valueForBatchingDisabled;
        }
    }
}

