package com.atlassian.labs.httpservice.resource;

import org.osgi.service.http.HttpContext;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.atlassian.labs.httpservice.resource.OsgiResourceHolder;
import com.atlassian.labs.httpservice.ServletManager;
import com.atlassian.plugin.servlet.util.PathMapper;
import com.atlassian.plugin.servlet.util.DefaultPathMapper;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.servlet.PluginHttpRequestWrapper;

/**
 *
 */
public class ResourceFilter implements Filter
{
    private final Map<String, OsgiResourceHolder> resources;
    private final PathMapper pathMapper;
    private final ServletManager servletManager;

    public ResourceFilter(ServletManager servletManager)
    {
        this.servletManager = servletManager;
        resources = new ConcurrentHashMap<String, OsgiResourceHolder>();
        pathMapper = new DefaultPathMapper();
    }


    public void init(FilterConfig filterConfig) throws ServletException
    {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException
    {
        boolean handled = false;
        
        // Guess the servlet this resource is meant to be complementing
        ServletModuleDescriptor descriptor = servletManager.guessContext(((HttpServletRequest) request).getPathInfo());
        HttpServletRequest servletRequest = descriptor != null ? new PluginHttpRequestWrapper((HttpServletRequest)request, descriptor) : (HttpServletRequest) request;

        for (String key : pathMapper.getAll(findPath(request)))
        {
            if (resources.get(key).handle(servletRequest, response))
            {
                handled = true;
                break;
            }
        }

        if (!handled)
        {
            chain.doFilter(request, response);
        }

    }

    public void destroy()
    {
        resources.clear();
    }

    public void addResource(String alias, String name, HttpContext osgiHttpContext)
    {
        OsgiResourceHolder holder = new OsgiResourceHolder(name, osgiHttpContext);
        String key = String.valueOf(holder.hashCode());

        // add wilcard filter at the end of the alias to allow servlet to
        // get requests which include sub-paths
        String pattern = "/".equals( alias ) ? "/*" : alias + "/*";
        pathMapper.put(key, pattern);
        resources.put(key, holder);
    }

    private static String findPath(ServletRequest request)
    {
        String target = ((HttpServletRequest)request).getPathInfo();
        if (target == null)
        {
            target = "";
        }

        if (!target.startsWith("/"))
        {
            target += "/" + target;
        }
        return target;
    }

}
