/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.httpservice.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.http.HttpContext;

class OsgiResourceHolder {
    private HttpContext m_osgiHttpContext;
    private AccessControlContext m_acc;
    private String m_path;
    private static final Log log = LogFactory.getLog(OsgiResourceHolder.class);

    public OsgiResourceHolder(String path, HttpContext httpContext) {
        this.m_osgiHttpContext = httpContext;
        this.m_path = path;
        if (this.m_path == null) {
            this.m_path = "";
        }
        if (System.getSecurityManager() != null) {
            this.m_acc = AccessController.getContext();
        }
    }

    public boolean handle(ServletRequest sRequest, ServletResponse sResponse) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)sRequest;
        HttpServletResponse response = (HttpServletResponse)sResponse;
        String target = request.getPathInfo();
        if (target == null) {
            target = "";
        }
        if (!target.startsWith("/")) {
            target = target + "/" + target;
        }
        log.debug((Object)("handle for name:" + this.m_path + " (path=" + target + ")"));
        if (!this.m_osgiHttpContext.handleSecurity(request, response)) {
            try {
                response.sendError(403);
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String resName = target;
        log.debug((Object)("** looking for: " + resName));
        URL url = this.m_osgiHttpContext.getResource(resName);
        if (url == null) {
            return false;
        }
        log.debug((Object)("serving up:" + resName));
        String method = request.getMethod();
        if (method.equalsIgnoreCase("get") || method.equalsIgnoreCase("post") || method.equalsIgnoreCase("head")) {
            this.handleGet(request, response, url, resName);
        } else {
            try {
                response.sendError(501);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public void handleGet(HttpServletRequest request, final HttpServletResponse response, final URL url, String resName) throws IOException {
        String encoding = this.m_osgiHttpContext.getMimeType(resName);
        response.setContentType(encoding);
        long lastModified = this.getLastModified(url);
        if (lastModified != 0L) {
            response.setDateHeader("Last-Modified", lastModified);
        }
        if (!this.resourceModified(lastModified, request.getDateHeader("If-Modified-Since"))) {
            response.setStatus(304);
        } else if (this.m_acc != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        OsgiResourceHolder.this.copyResourceBytes(url, response);
                        return null;
                    }
                }, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                IOException ioe = (IOException)ex.getException();
                throw ioe;
            }
        } else {
            this.copyResourceBytes(url, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceBytes(URL url, HttpServletResponse response) throws IOException {
        ServletOutputStream os = null;
        InputStream is = null;
        try {
            os = response.getOutputStream();
            is = url.openStream();
            int len = 0;
            byte[] buf = new byte[1024];
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                os.write(buf, 0, n);
                len += n;
            }
            try {
                response.setContentLength(len);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"OsgiResourceHandler", (Throwable)ex);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    protected long getLastModified(URL resUrl) {
        File f;
        String filepath;
        long lastModified = 0L;
        try {
            URLConnection conn = resUrl.openConnection();
            lastModified = conn.getLastModified();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (lastModified == 0L && (filepath = resUrl.getPath()) != null && (f = new File(filepath)).exists()) {
            lastModified = f.lastModified();
        }
        log.debug((Object)("url: " + resUrl + ", lastModified:" + lastModified));
        return lastModified;
    }

    protected boolean resourceModified(long resTimestamp, long modSince) {
        boolean retval = false;
        if ((resTimestamp /= 1000L) == 0L || (modSince /= 1000L) == -1L || resTimestamp > modSince) {
            retval = true;
        }
        return retval;
    }
}

