package com.atlassian.labs.httpservice.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.hostcontainer.DefaultHostContainer;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.filter.FilterLocation;

import javax.servlet.Filter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 */
public class LegacyHttpServiceServletFilterModuleDescriptor extends ServletFilterModuleDescriptor
{
    private final List<String> paths;
    private final Map<String, String> initParams;
    private final String completeKey;
    private final String key;
    private final Plugin plugin;
    private final Filter filter;

    /**
     * Creates a descriptor that uses a module factory to create instances
     *
     * @since 2.2.0
     */
    public LegacyHttpServiceServletFilterModuleDescriptor(Plugin plugin, Filter filter, String alias, Dictionary initParams, ServletModuleManager servletModuleManager)
    {
        super(new DefaultHostContainer(), servletModuleManager);
        this.plugin = plugin;
        this.filter = filter;
        paths = Arrays.asList(alias);
        Map<String,String> tmp = new HashMap<String, String>();
        for (Enumeration e = initParams.keys(); e.hasMoreElements(); )
        {
            String key = (String) e.nextElement();
            tmp.put(key, (String) initParams.get(key));
        }
        this.initParams = Collections.unmodifiableMap(tmp);
        this.key = alias + filter.getClass().getSimpleName();
        this.completeKey = plugin.getKey() + ":" + this.key;
    }

    @Override
    public String getPluginKey()
    {
        return plugin.getKey();
    }

    @Override
    public FilterLocation getLocation()
    {
        return FilterLocation.BEFORE_DISPATCH;
    }

    @Override
    public Plugin getPlugin()
    {
        return plugin;
    }

    @Override
    public Filter getModule()
    {
        return filter;
    }

    @Override
    public String getKey()
    {
        return this.key;
    }

    @Override
    public String getCompleteKey()
    {
        return completeKey;
    }

    @Override
    public String getName()
    {
        return filter.getClass().getSimpleName();
    }

    @Override
    public Class<Filter> getModuleClass()
    {
        return (Class<Filter>) filter.getClass();
    }

    @Override
    public List<String> getPaths()
    {
        return paths;
    }

    @Override
    public Map<String,String> getInitParams()
    {
        return initParams;
    }
}
