/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.io.IOException;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchService;
import name.pachler.nio.file.ext.ExtendedWatchEventKind;
import name.pachler.nio.file.ext.ExtendedWatchEventModifier;
import name.pachler.nio.file.impl.PathImpl;
import name.pachler.nio.file.impl.PathWatchKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PathWatchService
extends WatchService {
    protected static final int FLAG_WATCH_SUBTREE = 4096;
    protected static final int FLAG_ACCURATE = 8192;
    protected static final int FLAG_FILTER_ENTRY_RENAME_FROM = 2;
    protected static final int FLAG_FILTER_ENTRY_RENAME_TO = 4;
    protected static final int FLAG_FILTER_ENTRY_CREATE = 8;
    protected static final int FLAG_FILTER_ENTRY_DELETE = 16;
    protected static final int FLAG_FILTER_ENTRY_MODIFY = 32;
    protected static final int FLAG_FILTER_KEY_INVALID = 64;

    public abstract PathWatchKey register(Path var1, WatchEvent.Kind<?>[] var2, WatchEvent.Modifier[] var3) throws IOException;

    abstract void cancel(PathWatchKey var1);

    abstract boolean reset(PathWatchKey var1);

    protected int makeFlagMask(WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) {
        int flags = 0;
        for (WatchEvent.Kind<?> kind : kinds) {
            if (kind == StandardWatchEventKind.ENTRY_CREATE) {
                flags |= 8;
                continue;
            }
            if (kind == StandardWatchEventKind.ENTRY_DELETE) {
                flags |= 0x10;
                continue;
            }
            if (kind == StandardWatchEventKind.ENTRY_MODIFY) {
                flags |= 0x20;
                continue;
            }
            if (kind == ExtendedWatchEventKind.ENTRY_RENAME_FROM) {
                flags |= 2;
                continue;
            }
            if (kind == ExtendedWatchEventKind.ENTRY_RENAME_TO) {
                flags |= 4;
                continue;
            }
            if (kind == ExtendedWatchEventKind.KEY_INVALID) {
                flags |= 0x40;
                continue;
            }
            if (kind == StandardWatchEventKind.OVERFLOW) continue;
            throw new UnsupportedOperationException("unsupported event kind " + kind.name());
        }
        if ((flags & 0x40) == flags) {
            throw new IllegalArgumentException("ExtendedWatchEventKind.KEY_INVALID cannot be the only event kind specified");
        }
        for (WatchEvent.Modifier m : modifiers) {
            if (m == ExtendedWatchEventModifier.FILE_TREE) {
                flags |= 0x1000;
                continue;
            }
            if (m == ExtendedWatchEventModifier.ACCURATE) {
                flags |= 0x2000;
                continue;
            }
            throw new UnsupportedOperationException("unsupported modifier " + m.name());
        }
        return flags;
    }

    protected PathImpl checkAndCastToPathImpl(Path path) throws IOException {
        PathImpl pathImpl;
        try {
            pathImpl = (PathImpl)path;
        }
        catch (ClassCastException ccx) {
            throw new IllegalArgumentException("the provided Path was not created by the newPath factory method of name.pachler.nio.file.ext.Bootstrapper");
        }
        if (!pathImpl.getFile().isDirectory()) {
            throw new IOException("path " + pathImpl.toString() + " is not a directory");
        }
        return pathImpl;
    }
}

