/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket;

import com.netiq.websocket.Draft;
import com.netiq.websocket.HandshakedataImpl1;
import com.netiq.websocket.WebSocket;
import com.netiq.websocket.WebSocketAdapter;
import com.netiq.websocket.drafts.Draft_10;
import com.netiq.websocket.exceptions.InvalidHandshakeException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class WebSocketClient
extends WebSocketAdapter
implements Runnable {
    private URI uri = null;
    private WebSocket conn = null;
    private SocketChannel client = null;
    private Selector selector = null;
    private boolean running = false;
    private Draft draft = null;
    private int number1 = 0;
    private int number2 = 0;
    private byte[] key3 = null;

    public WebSocketClient(URI serverURI) {
        this(serverURI, new Draft_10());
    }

    public WebSocketClient(URI serverUri, Draft draft) {
        this.uri = serverUri;
        if (draft == null) {
            throw new IllegalArgumentException("null is permitted for `WebSocketServer` only!");
        }
        this.draft = draft;
    }

    public URI getURI() {
        return this.uri;
    }

    public Draft getDraft() {
        return this.draft;
    }

    public void connect() {
        if (!this.running) {
            this.running = true;
            new Thread(this).start();
        }
    }

    public void close() throws IOException {
        if (this.running) {
            this.running = false;
            if (this.selector != null && this.conn != null) {
                this.selector.wakeup();
                this.conn.close();
            } else {
                this.onClose(this.conn);
            }
        }
    }

    public void send(String text) throws IOException {
        if (this.conn != null) {
            this.conn.send(text);
        }
    }

    public void releaseAndInitialize() {
        this.conn = null;
        this.client = null;
        this.selector = null;
        this.running = false;
        this.draft = null;
        this.number1 = 0;
        this.number2 = 0;
        this.key3 = null;
    }

    private boolean tryToConnect(InetSocketAddress remote) {
        try {
            this.client = SocketChannel.open();
            this.client.configureBlocking(false);
            this.client.connect(remote);
            this.selector = Selector.open();
            this.conn = new WebSocket(this.client, new LinkedBlockingQueue<ByteBuffer>(), this, this.draft, Integer.MAX_VALUE);
            if (this.client != null) {
                this.client.register(this.selector, 8);
            }
        }
        catch (IOException ex) {
            this.onIOError(this.conn, ex);
            return false;
        }
        return true;
    }

    public void run() {
        this.running = this.tryToConnect(new InetSocketAddress(this.uri.getHost(), this.getPort()));
        while (this.running) {
            SelectionKey key = null;
            try {
                this.selector.select();
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = keys.iterator();
                while (i.hasNext()) {
                    key = i.next();
                    i.remove();
                    if (key.isConnectable()) {
                        this.finishConnect();
                    }
                    if (!key.isReadable()) continue;
                    this.conn.handleRead();
                }
            }
            catch (IOException ex) {
                if (key != null) {
                    key.cancel();
                }
                this.onIOError(this.conn, ex);
            }
            catch (Exception ex) {
                this.onError(ex);
            }
        }
    }

    private int getPort() {
        int port = this.uri.getPort();
        return port == -1 ? 80 : port;
    }

    private void finishConnect() throws IOException, InvalidHandshakeException {
        if (this.client.isConnectionPending()) {
            this.client.finishConnect();
        }
        this.client.register(this.selector, 1);
        this.sendHandshake();
    }

    private void sendHandshake() throws IOException, InvalidHandshakeException {
        String path = this.uri.getPath();
        if (path.indexOf("/") != 0) {
            path = "/" + path;
        }
        int port = this.getPort();
        String host = this.uri.getHost() + (port != 80 ? ":" + port : "");
        String origin = "x";
        HandshakedataImpl1 handshake = new HandshakedataImpl1();
        handshake.setResourceDescriptor(path);
        handshake.put("Host", host);
        handshake.put("Origin", origin);
        this.conn.startHandshake(handshake);
    }

    public void onMessage(WebSocket conn, String message) {
        this.onMessage(message);
    }

    public void onOpen(WebSocket conn) {
        this.onOpen();
    }

    public void onClose(WebSocket conn) {
        this.onClose();
        this.releaseAndInitialize();
    }

    public void onIOError(WebSocket conn, IOException ex) {
        this.releaseAndInitialize();
        this.onIOError(ex);
    }

    public abstract void onMessage(String var1);

    public abstract void onOpen();

    public abstract void onClose();

    public abstract void onIOError(IOException var1);
}

