/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket;

import com.netiq.websocket.Framedata;
import com.netiq.websocket.HandshakeBuilder;
import com.netiq.websocket.Handshakedata;
import com.netiq.websocket.HandshakedataImpl1;
import com.netiq.websocket.WebSocket;
import com.netiq.websocket.exceptions.InvalidHandshakeException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Draft {
    private static final byte[] FLASH_POLICY_REQUEST = WebSocket.utf8Bytes("<policy-file-request/>");

    public static int findNewLine(byte[] arr, int offset) {
        int i;
        int len = arr.length - 1;
        for (i = offset; i < len; ++i) {
            if (arr[i] != 13 || arr[i + 1] != 10) continue;
            return i;
        }
        return i;
    }

    public static boolean isFlashEdgeCase(byte[] request, int requestsize) {
        for (int i = 0; i < requestsize && i < FLASH_POLICY_REQUEST.length; ++i) {
            if (FLASH_POLICY_REQUEST[i] == request[i]) continue;
            return false;
        }
        return requestsize >= FLASH_POLICY_REQUEST.length;
    }

    public static HandshakeBuilder translateHandshakeHttp(byte[] buffer, int readcount) throws InvalidHandshakeException {
        HandshakedataImpl1 draft = new HandshakedataImpl1();
        ByteBuffer message = ByteBuffer.allocate(readcount);
        message.put(buffer, 0, readcount);
        byte[] lines = message.array();
        int previndex = 0;
        int index = Draft.findNewLine(lines, previndex);
        if (index == lines.length) {
            throw new InvalidHandshakeException("not an http header");
        }
        String line = new String(lines, previndex, index - previndex);
        String[] firstLineTokens = line.split(" ");
        String path = firstLineTokens[1];
        draft.setResourceDescriptor(path);
        previndex = index + 2;
        index = Draft.findNewLine(lines, previndex);
        int length = index - previndex;
        while (length != 0) {
            line = new String(lines, previndex, length);
            if (index != previndex) {
                String[] pair = line.split(":", 2);
                if (pair.length != 2) {
                    throw new InvalidHandshakeException("not an http header");
                }
                draft.put(pair[0], pair[1].replaceFirst("^ +", ""));
            }
            previndex = index + 2;
            index = Draft.findNewLine(lines, previndex);
            length = index - previndex;
        }
        previndex = index + 2;
        length = lines.length - previndex;
        draft.setContent(ByteBuffer.allocate(length).put(lines, previndex, length).array());
        return draft;
    }

    public abstract HandshakeState acceptHandshakeAsClient(Handshakedata var1, Handshakedata var2) throws InvalidHandshakeException;

    public abstract HandshakeState acceptHandshakeAsServer(Handshakedata var1) throws InvalidHandshakeException;

    protected boolean basicAccept(Handshakedata handshakedata) {
        return handshakedata.getFieldValue("Upgrade").equalsIgnoreCase("websocket") && handshakedata.getFieldValue("Connection").toLowerCase(Locale.ENGLISH).contains("upgrade");
    }

    public abstract ByteBuffer createBinaryFrame(Framedata var1);

    public abstract List<Framedata> createFrames(byte[] var1, boolean var2);

    public abstract List<Framedata> createFrames(String var1, boolean var2);

    public List<ByteBuffer> createHandshake(Handshakedata handshakedata, WebSocket.Role ownrole) {
        return this.createHandshake(handshakedata, ownrole, true);
    }

    public List<ByteBuffer> createHandshake(Handshakedata handshakedata, WebSocket.Role ownrole, boolean withcontent) {
        StringBuilder bui = new StringBuilder(100);
        if (ownrole == WebSocket.Role.CLIENT) {
            bui.append("GET ");
            bui.append(handshakedata.getResourceDescriptor());
            bui.append(" HTTP/1.1");
        } else if (ownrole == WebSocket.Role.SERVER) {
            bui.append("HTTP/1.1 101 " + handshakedata.getHttpStatusMessage());
        } else {
            throw new RuntimeException("unknow role");
        }
        bui.append("\r\n");
        Iterator<String> it = handshakedata.iterateHttpFields();
        while (it.hasNext()) {
            String fieldname = it.next();
            String fieldvalue = handshakedata.getFieldValue(fieldname);
            bui.append(fieldname);
            bui.append(": ");
            bui.append(fieldvalue);
            bui.append("\r\n");
        }
        bui.append("\r\n");
        byte[] httpheader = WebSocket.utf8Bytes(bui.toString());
        byte[] content = withcontent ? handshakedata.getContent() : null;
        ByteBuffer bytebuffer = ByteBuffer.allocate((content == null ? 0 : content.length) + httpheader.length);
        bytebuffer.put(httpheader);
        if (content != null) {
            bytebuffer.put(content);
        }
        bytebuffer.flip();
        return Collections.singletonList(bytebuffer);
    }

    public abstract HandshakeBuilder postProcessHandshakeRequestAsClient(HandshakeBuilder var1) throws InvalidHandshakeException;

    public abstract HandshakeBuilder postProcessHandshakeResponseAsServer(Handshakedata var1, HandshakeBuilder var2) throws InvalidHandshakeException;

    public abstract List<Framedata> translateFrame(ByteBuffer var1, int var2);

    public Handshakedata translateHandshake(byte[] buffer, int readcount) throws InvalidHandshakeException {
        return Draft.translateHandshakeHttp(buffer, readcount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HandshakeState {
        MATCHED,
        NOT_MATCHED,
        MATCHING;

    }
}

