/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.livereload;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.livereload.LiveReloadEvent;
import com.atlassian.livereload.LiveReloadServer;
import com.google.gson.Gson;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class LiveReloadEventHandler
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(LiveReloadEventHandler.class);
    private final LiveReloadServer liveReloadServer;
    private final EventPublisher eventPublisher;

    public LiveReloadEventHandler(LiveReloadServer liveReloadServer, EventPublisher eventPublisher) {
        this.liveReloadServer = liveReloadServer;
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onLiveReloadEvent(LiveReloadEvent event) {
        try {
            Gson gson = new Gson();
            String command = gson.toJson(new ReloadCommand(event.getPath()));
            log.debug("sending command to socket:");
            log.debug(command);
            this.liveReloadServer.sendToAll(command);
        }
        catch (IOException e) {
            log.error("Unable to send message via socket server!", (Throwable)e);
            e.printStackTrace();
        }
    }

    static class ReloadCommand {
        private String command = "reload";
        private String path;
        private Boolean liveCSS;

        ReloadCommand(String path) {
            this.path = path;
            this.liveCSS = true;
        }
    }
}

