/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev.rest.representations;

import com.atlassian.fastdev.maven.MavenTask;
import com.atlassian.fastdev.maven.MavenTaskManager;
import com.atlassian.fastdev.rest.FastdevUriBuilder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class MavenTaskCollectionRepresentation {
    @JsonProperty
    private final Collection<MavenTaskSummaryRepresentation> tasks;
    @JsonProperty
    private final Map<String, URI> links;

    @JsonCreator
    public MavenTaskCollectionRepresentation(@JsonProperty(value="tasks") Collection<MavenTaskSummaryRepresentation> tasks, @JsonProperty(value="links") Map<String, URI> links) {
        this.tasks = ImmutableList.copyOf(tasks);
        this.links = ImmutableMap.copyOf(links);
    }

    public MavenTaskCollectionRepresentation(MavenTaskManager taskManager, final FastdevUriBuilder uriBuilder) {
        this.tasks = ImmutableList.copyOf((Iterable)Iterables.transform(taskManager.getAllTasks(), (Function)new Function<MavenTask, MavenTaskSummaryRepresentation>(){

            public MavenTaskSummaryRepresentation apply(MavenTask mavenTask) {
                return new MavenTaskSummaryRepresentation(mavenTask, uriBuilder);
            }
        }));
        this.links = ImmutableMap.of((Object)"self", (Object)uriBuilder.buildMavenTaskCollectionUri());
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public static class MavenTaskSummaryRepresentation {
        @JsonProperty
        private final Map<String, URI> links;
        @JsonProperty
        private final String id;
        @JsonProperty
        private final Long averageTaskTime;
        @JsonProperty
        private final Long elapsedTime;
        @JsonProperty
        private final String buildRoot;

        @JsonCreator
        public MavenTaskSummaryRepresentation(@JsonProperty(value="links") Map<String, URI> links, @JsonProperty(value="id") String id, @JsonProperty(value="averageTaskTime") Long averageTaskTime, @JsonProperty(value="buildRoot") String buildRoot, @JsonProperty(value="elapsedTime") Long elapsedTime) {
            this.links = ImmutableMap.copyOf(links);
            this.id = id;
            this.averageTaskTime = averageTaskTime;
            this.buildRoot = buildRoot;
            this.elapsedTime = elapsedTime;
        }

        public MavenTaskSummaryRepresentation(MavenTask task, FastdevUriBuilder uriBuilder) {
            this.links = ImmutableMap.of((Object)"self", (Object)uriBuilder.buildMavenTaskUri(task));
            this.id = task.getUuid().toString();
            this.averageTaskTime = task.getAverageTaskTime();
            this.buildRoot = task.getBuildRoot().getAbsolutePath();
            this.elapsedTime = task.getElapsedTime();
        }
    }
}

