package com.atlassian.fastdev;

import java.io.File;
import java.net.URI;

import com.atlassian.fastdev.maven.MavenTaskManager;
import com.atlassian.sal.api.ApplicationProperties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Builds and reloads plugins for a given root directory
 */
public class PluginReloader
{
    private final Logger LOG = LoggerFactory.getLogger(AutoReloadFilter.class);
    private final ApplicationProperties applicationProperties;
    private final MavenTaskManager taskManager;

    public PluginReloader(ApplicationProperties applicationProperties,
                          MavenTaskManager taskManager)
    {
        this.applicationProperties = applicationProperties;
        this.taskManager = taskManager;
    }

    public void pluginInstall(final File root)
    {
        URI baseUri = URI.create(applicationProperties.getBaseUrl());
        int httpPort = baseUri.getPort();
        String contextPath = baseUri.getPath();

        File buildRoot = root.getParentFile().getParentFile();

        if (!buildRoot.isDirectory() || !new File(buildRoot, "pom.xml").exists())
        {
            LOG.warn(buildRoot.getPath() + " does not contain pom.xml. Skipping");
        }

        for (MavenTaskManager.MavenTask task : taskManager.createTask(buildRoot,
                "resources:resources",
                "com.atlassian.maven.plugins:maven-amps-plugin:filter-plugin-descriptor",
                "compile",
                "com.atlassian.maven.plugins:maven-amps-plugin:copy-bundled-dependencies",
                "com.atlassian.maven.plugins:maven-amps-plugin:compress-resources",
                "com.atlassian.maven.plugins:maven-amps-plugin:generate-manifest",
                "com.atlassian.maven.plugins:maven-amps-plugin:jar",
                "com.atlassian.maven.plugins:maven-amps-plugin:install",
                "-Dhttp.port=" + httpPort,
                "-Dcontext.path=" + contextPath).right())
        {
            LOG.info("Executing mvn process in " + buildRoot.getPath());
            task.start();
        }

    }
}
