/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev;

import com.atlassian.fastdev.FastdevProperties;
import com.atlassian.fastdev.PluginReloader;
import com.atlassian.fastdev.TargetScanner;
import com.atlassian.fastdev.util.Option;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadHandler {
    private final Logger LOG = LoggerFactory.getLogger(ReloadHandler.class);
    private final PluginReloader pluginReloader;
    private final TemplateRenderer renderer;
    private final TargetScanner targetScanner;
    private final ApplicationProperties applicationProperties;
    private final FastdevProperties fastdevProperties;

    public ReloadHandler(TemplateRenderer renderer, TargetScanner targetScanner, PluginReloader pluginReloader, ApplicationProperties applicationProperties, FastdevProperties fastdevProperties) {
        this.renderer = renderer;
        this.targetScanner = targetScanner;
        this.pluginReloader = pluginReloader;
        this.applicationProperties = applicationProperties;
        this.fastdevProperties = fastdevProperties;
    }

    public Option<String> reloadPlugins() throws IOException {
        Set<File> roots = this.targetScanner.scan();
        if (!roots.isEmpty()) {
            this.LOG.info("Detected changes that require plugin reload, reloading...");
            ImmutableMap context = ImmutableMap.of((Object)"baseurl", (Object)URI.create(this.applicationProperties.getBaseUrl()).normalize().toASCIIString(), (Object)"version", (Object)this.fastdevProperties.getFastdevVersion());
            StringWriter output = new StringWriter();
            this.renderer.render("fastdev-output.vm", (Map)context, (Writer)output);
            for (File root : roots) {
                this.LOG.info("Reloading plugin at " + root.getPath());
                this.pluginReloader.pluginInstall(root);
            }
            return Option.some(output.toString());
        }
        this.LOG.info("Detected no changes that require plugin reload.  Not reloading.");
        return Option.none();
    }
}

