package com.atlassian.json.marshal;

import com.atlassian.annotations.PublicApi;

/**
 * A factory that can marshal objects into {@link Jsonable} objects, ie objects that can write themselves out to a stream
 * in JSON format.
 */
@PublicApi
public interface JsonableMarshaller
{
    /**
     * Call this to create a {@link Jsonable} for the provided object.  The object can be a simple POJO or it can have JAXB a/ Jackson
     * annotations on it to allow it to be turned into JSON.
     *
     * @param toJsonObj the object to wrap as a {@link Jsonable}
     * @return a {@link Jsonable} object
     */
    Jsonable marshal(final Object toJsonObj);
}
