/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Project;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ProjectJsonParser
implements JsonParser<Project> {
    private final VersionJsonParser versionJsonParser = new VersionJsonParser();
    private final BasicComponentJsonParser componentJsonParser = new BasicComponentJsonParser();

    @Override
    public Project parse(JSONObject json) throws JSONException {
        URI uri;
        URI self = JsonParseUtil.getSelfUri(json);
        BasicUser lead = JsonParseUtil.parseBasicUser(json.getJSONObject("lead"));
        String key = json.getString("key");
        String urlStr = json.getString("url");
        try {
            uri = "".equals(urlStr) ? null : new URI(urlStr);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        String description = json.getString("description");
        Collection<Version> versions = JsonParseUtil.parseJsonArray(json.getJSONArray("versions"), this.versionJsonParser);
        Collection<BasicComponent> components = JsonParseUtil.parseJsonArray(json.getJSONArray("components"), this.componentJsonParser);
        return new Project(self, key, description, lead, uri, versions, components);
    }
}

