/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.SessionRestClient;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.Session;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.Votes;
import com.atlassian.jira.rest.client.domain.Watchers;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParser;
import com.atlassian.jira.rest.client.internal.json.VotesJsonParser;
import com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import com.atlassian.jira.rest.client.internal.json.gen.CommentJsonGenerator;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JerseyIssueRestClient
extends AbstractJerseyRestClient
implements IssueRestClient {
    private final SessionRestClient sessionRestClient;
    private final IssueJsonParser issueParser = new IssueJsonParser();
    private final JsonParser<Watchers> watchersParser = WatchersJsonParserBuilder.createWatchersParser();
    private final TransitionJsonParser transitionJsonParser = new TransitionJsonParser();
    private final CommentJsonGenerator commentJsonGenerator = new CommentJsonGenerator();
    private final VotesJsonParser votesJsonParser = new VotesJsonParser();

    public JerseyIssueRestClient(URI baseUri, ApacheHttpClient client, SessionRestClient sessionRestClient) {
        super(baseUri, client);
        this.sessionRestClient = sessionRestClient;
    }

    @Override
    public Watchers getWatchers(URI watchersUri, ProgressMonitor progressMonitor) {
        return this.getAndParse(watchersUri, this.watchersParser, progressMonitor);
    }

    @Override
    public Votes getVotes(URI votesUri, ProgressMonitor progressMonitor) {
        return this.getAndParse(votesUri, this.votesJsonParser, progressMonitor);
    }

    @Override
    public Issue getIssue(String issueKey, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri);
        uriBuilder.path("issue").path(issueKey);
        return this.getAndParse(uriBuilder.build(new Object[0]), this.issueParser, progressMonitor);
    }

    @Override
    public Iterable<Transition> getTransitions(final URI transitionsUri, ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<Iterable<Transition>>(){

            @Override
            public Iterable<Transition> call() throws Exception {
                WebResource transitionsResource = JerseyIssueRestClient.this.client.resource(transitionsUri);
                JSONObject jsonObject = (JSONObject)transitionsResource.get(JSONObject.class);
                ArrayList<Transition> transitions = new ArrayList<Transition>(jsonObject.length());
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    try {
                        int id = Integer.parseInt(key);
                        Transition transition = JerseyIssueRestClient.this.transitionJsonParser.parse(jsonObject.getJSONObject(key), id);
                        transitions.add(transition);
                    }
                    catch (JSONException e) {
                        throw new RestClientException(e);
                    }
                    catch (NumberFormatException e) {
                        throw new RestClientException("Transition id should be an integer, but found [" + key + "]", (Throwable)e);
                    }
                }
                return transitions;
            }
        });
    }

    @Override
    public void transition(final URI transitionsUri, final TransitionInput transitionInput, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("transition", transitionInput.getId());
                if (transitionInput.getComment() != null) {
                    jsonObject.put("comment", (Object)JerseyIssueRestClient.this.commentJsonGenerator.generate(transitionInput.getComment()));
                }
                JSONObject fieldsJs = new JSONObject();
                Iterable<FieldInput> fields = transitionInput.getFields();
                if (fields.iterator().hasNext()) {
                    for (FieldInput fieldInput : fields) {
                        fieldsJs.put(fieldInput.getId(), fieldInput.getValue());
                    }
                }
                if (fieldsJs.keys().hasNext()) {
                    jsonObject.put("fields", (Object)fieldsJs);
                }
                WebResource issueResource = JerseyIssueRestClient.this.client.resource(transitionsUri);
                issueResource.post((Object)jsonObject);
                return null;
            }
        });
    }

    @Override
    public void vote(final URI votesUri, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource votesResource = JerseyIssueRestClient.this.client.resource(votesUri);
                votesResource.post();
                return null;
            }
        });
    }

    @Override
    public void unvote(final URI votesUri, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource votesResource = JerseyIssueRestClient.this.client.resource(votesUri);
                votesResource.delete();
                return null;
            }
        });
    }

    @Override
    public void addWatcher(final URI watchersUri, final @Nullable String username, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource.Builder builder = JerseyIssueRestClient.this.client.resource(watchersUri).type(MediaType.APPLICATION_JSON_TYPE);
                if (username != null) {
                    builder.post((Object)JSONObject.quote((String)username));
                } else {
                    builder.post();
                }
                return null;
            }
        });
    }

    private String getLoggedUsername(ProgressMonitor progressMonitor) {
        Session session = this.sessionRestClient.getCurrentSession(progressMonitor);
        return session.getUsername();
    }

    @Override
    public void removeWatcher(final URI watchersUri, final String username, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URI uri = UriBuilder.fromUri((URI)watchersUri).path(username).build(new Object[0]);
                WebResource watchersResource = JerseyIssueRestClient.this.client.resource(uri);
                watchersResource.delete();
                return null;
            }
        });
    }

    @Override
    public void watch(URI watchersUri, ProgressMonitor progressMonitor) {
        this.addWatcher(watchersUri, null, progressMonitor);
    }

    @Override
    public void unwatch(URI watchersUri, ProgressMonitor progressMonitor) {
        this.removeWatcher(watchersUri, this.getLoggedUsername(progressMonitor), progressMonitor);
    }
}

