AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.GlobalTransitionView", {
    /**
     * @return {JIRA.WorkflowDesigner.TransitionView} A newly created `GlobalTransitionView`.
     */
    createGlobalTransitionView: function () {
        var statusModel = new JIRA.WorkflowDesigner.StatusModel();
        this.canvasView.addStatus(statusModel);

        return this.canvasView.addTransition(new JIRA.WorkflowDesigner.TransitionModel({
            globalTransition: true,
            target: statusModel
        }));
    },

    setup: function () {
        this.sandbox = sinon.sandbox.create();

        this.canvasView = JIRA.WorkflowDesigner.TestUtilities.testCanvasView();
        this.editStub = this.sandbox.stub(JIRA.WorkflowDesigner.GlobalTransitionView.prototype, "edit");
    },

    teardown: function() {
        JIRA.WorkflowDesigner.TestUtilities.removeDialogs();
        this.sandbox.restore();
    }
});

test("Double clicking a global transition initiates editing", function () {
    JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function () {
        var globalTransitionView;

        globalTransitionView = this.createGlobalTransitionView();
        globalTransitionView._figure.onDoubleClick();
        equal(this.editStub.callCount, 1, "GlobalTransitionView#edit() was called");
    }, this);
});

test("Double clicking a global transition doesn't initiate editing when immutable", function () {
    JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function () {
        var globalTransitionView;

        this.canvasView = JIRA.WorkflowDesigner.TestUtilities.testCanvasView({immutable: true});
        globalTransitionView = this.createGlobalTransitionView();
        globalTransitionView._figure.onDoubleClick();
        equal(this.editStub.callCount, 0, "GlobalTransitionView#edit() wasn't called when immutable");
    }, this);
});

test("The figure is added to the \"global-transitions\" layer", function () {
    JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function () {
        var figure,
            layer = this.canvasView.canvas.getLayer("global-transitions");

        sinon.spy(layer, "addFigure");
        figure = this.createGlobalTransitionView()._figure;

        equal(layer.addFigure.callCount, 1, "The global-transitions layer's #addFigure() method was called");
        ok(layer.addFigure.args[0][0] === figure, "It was passed the correct figure");
    }, this);
});

test("The figure is moved to the \"selected-transition\" layer on selection", function () {
    JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function () {
        var globalTransitionsLayer = this.canvasView.canvas.getLayer("global-transitions"),
            selectedTransitionLayer = this.canvasView.canvas.getLayer("selected-transition"),
            view = this.createGlobalTransitionView();

        sinon.spy(globalTransitionsLayer, "addFigure");
        sinon.spy(selectedTransitionLayer, "addFigure");

        view.select();
        equal(selectedTransitionLayer.addFigure.callCount, 1, "The selected-transition layer's #addFigure() method was called");
        ok(selectedTransitionLayer.addFigure.args[0][0] === view._figure, "It was passed the correct figure");

        view.deselect();
        equal(globalTransitionsLayer.addFigure.callCount, 1, "The global-transition layer's #addFigure() method was called");
        ok(globalTransitionsLayer.addFigure.args[0][0] === view._figure, "It was passed the correct figure");
    }, this);
});