AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.StatusView",{allPortsAreVisible:function(A){return _.all(A.getPorts(),function(B){return B.isVisible()})},createStatusView:function(C){var B=_.bind(this.canvasView._getAllTargetPorts,this.canvasView),D=_.bind(this.canvasView._isPortDragged,this.canvasView),A;C=_.defaults({},C,{canvas:this.canvas,model:new JIRA.WorkflowDesigner.StatusModel(),getAllTargetPorts:B,isPortDragged:D,workflowModel:this.workflowModel});A=new JIRA.WorkflowDesigner.StatusView(C).render();this.canvasView.statusViews.add(A);return A},noPortsAreVisible:function(A){return _.all(A.getPorts(),function(B){return !B.isVisible()})},setup:function(){this.canvasView=JIRA.WorkflowDesigner.TestUtilities.testCanvasView();this.canvas=this.canvasView.canvas;this.sandbox=sinon.sandbox.create();this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel()},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});test("All ports are visible while dragging",function(){var C,B,A;C=this.createStatusView();ok(this.noPortsAreVisible(C),"Ports aren't visible initially");A=this.createStatusView();ok(this.noPortsAreVisible(A),"Ports aren't visible initially");B=A.getPorts()[0];B.onDragStart();ok(this.allPortsAreVisible(C),"All ports are visible on the target status");ok(_.all(_.tail(A.getPorts()),function(D){return D.isVisible()}),"All ports are visible on the source status except the one being dragged");B.onDragEnd();ok(this.noPortsAreVisible(C),"No ports are visible on the target status");ok(this.allPortsAreVisible(A),"All ports are visible on the source status")});test("destroy() shows a DeleteStatusDialogView",function(){var C,B=this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"DeleteStatusDialogView").returns({show:jQuery.noop}),A=this.createStatusView();A.destroy();equal(B.callCount,1,"A DeleteStatusDialogView was created");C=B.args[0];equal(C.length,1,"It was passed a single argument");equal(C[0].statusModel,A.model,"It was passed the correct StatusModel");equal(C[0].workflowModel,this.workflowModel,"It was passed the correct WorkflowModel")});test("Double clicking a status doesn't initiate editing when immutable",function(){var B=this.sandbox.stub(JIRA.WorkflowDesigner.StatusView.prototype,"edit"),A=this.createStatusView({immutable:true});A._figure.onDoubleClick();equal(B.callCount,0,"StatusView#edit() wasn't called")});test("Double clicking a status initiates editing",function(){var B=this.sandbox.stub(JIRA.WorkflowDesigner.StatusView.prototype,"edit"),A=this.createStatusView();A._figure.onDoubleClick();equal(B.callCount,1,"StatusView#edit() was called.")});test("Drag events are triggered",function(){var B;function A(C){var D=sinon.spy(),E=sinon.spy();C.bind("drag",E);C.bind("dragEnd",D);C._figure.onDrag();equal(E.callCount,1,"A drag event was triggered");C._figure.command=C._figure.createCommand(new draw2d.command.CommandType(draw2d.command.CommandType.MOVE));C._figure.onDragEnd();equal(D.callCount,1,"A dragEnd event was triggered")}B=[this.createStatusView(),this.createStatusView({immutable:true})];_.each(B,A)});test("Dragging a port selects the associated status",function(){var A=this.createStatusView();ok(!A.isSelected(),"The status isn't selected");A.getPorts()[0].onDragStart();ok(A.isSelected(),"The status is selected")});test("Dragging the view updates model coordinates",function(){var A;A=this.createStatusView();A.getBoundingBox=function(){return new draw2d.geo.Rectangle(100,200,10,10)};A._figure.onDragStart();A._figure.onDragEnd();equal(A.model.get("x"),100,"The model's x coordinate was updated");equal(A.model.get("y"),200,"The model's y coordinate was updated")});test("Highlight events are triggered on hover",function(){var B;function A(C){var D=sinon.spy(),E=sinon.spy();C.bind("highlight",D);C.bind("unhighlight",E);C._figure.onMouseEnter();equal(D.callCount,1,"A highlight event was fired");C._figure.onMouseLeave();equal(E.callCount,1,"An unhighlight event was fired")}B=[this.createStatusView(),this.createStatusView({immutable:true})];_.each(B,A)});test("Statuses are the correct colour when status lozenges are available",function(){var B,C=JIRA.WorkflowDesigner.StatusLozengeColours,A;this.sandbox.stub(C,"getBackgroundColour").returns("#ff0000");this.sandbox.spy(C,"getBorderColour");this.sandbox.stub(C,"getColour").returns("#00ff00");A=this.createStatusView({model:new JIRA.WorkflowDesigner.StatusModel({statusCategory:{colourName:"green",id:1}})});B=[{colourName:"green",isSubtle:false}];equal(C.getBackgroundColour.callCount,1,"StatusLozengeColours.getBackgroundColour was called");deepEqual(C.getBackgroundColour.args[0],B,"It was passed the correct arguments");equal(C.getBorderColour.callCount,0,"StatusLozengeColours.getBorderColour wasn't called");equal(C.getColour.callCount,1,"StatusLozengeColours.getColour was called");deepEqual(C.getColour.args[0],B,"It was passed the correct arguments");equal(A._figure.getBackgroundColor().hash(),"#FF0000","The status has the correct background colour");equal(A._figure.getColor().hash(),"#FFFFFF","The status has the correct border colour");equal(A._figure.getTextColor().hash(),"#00FF00","The status has the correct text colour")});test("Statuses are the correct colour when status lozenges aren't available",function(){var A=this.createStatusView();equal(A._figure.getBackgroundColor().hash(),"#4A6785","The status has the correct background colour");equal(A._figure.getColor().hash(),"#FFFFFF","The status has the correct border colour");equal(A._figure.getTextColor().hash(),"#FFFFFF","The status has the correct text colour")});test("Ports are shown on hover",function(){var A=this.createStatusView();ok(this.noPortsAreVisible(A),"Ports aren't visible initially");A._figure.onMouseEnter();ok(this.allPortsAreVisible(A),"Ports become visible on hover");A._figure.onMouseLeave();ok(this.noPortsAreVisible(A),"Ports are hidden on mouse leave")});test("Ports are shown on port hover",function(){var B,A;A=this.createStatusView();B=A.getPorts()[0];ok(this.noPortsAreVisible(A),"Ports aren't visible initially");B.onMouseEnter();ok(this.allPortsAreVisible(A),"Ports become visible on port hover");B.onMouseLeave();ok(this.noPortsAreVisible(A),"Ports are hidden on mouse leave")});test("Ports aren't hidden after moving from the status body to a port",function(){var B,A;A=this.createStatusView();B=A.getPorts()[0];ok(this.noPortsAreVisible(A),"Ports aren't visible initially");A._figure.onMouseEnter();ok(this.allPortsAreVisible(A),"Ports become visible on hover");A._figure.onMouseLeave(B);ok(this.allPortsAreVisible(A),"Ports are still visible as the new figure is a port");B.onMouseLeave(A._figure);ok(this.allPortsAreVisible(A),"Ports are still visible as the new figure is the status")});test("Ports aren't shown on hover when immutable",function(){var A=this.createStatusView({immutable:true});ok(this.noPortsAreVisible(A),"Ports aren't visible initially");A._figure.onMouseEnter();ok(this.noPortsAreVisible(A),"Ports aren't visible on hover")});test("Statuses are the correct colour when status lozenges are available in subtle mode",function(){var A,C,B,D=JIRA.WorkflowDesigner.StatusLozengeColours;this.sandbox.stub(D,"getBackgroundColour").returns("#ff0000");this.sandbox.stub(D,"getBorderColour").returns("#00ff00");this.sandbox.stub(D,"getColour").returns("#0000ff");this.canvasView=JIRA.WorkflowDesigner.TestUtilities.testCanvasView({workflowModel:new JIRA.WorkflowDesigner.WorkflowModel({currentStepId:1})});A=this.canvasView.addStatus(new JIRA.WorkflowDesigner.StatusModel({statusCategory:{colourName:"green",id:1},stepId:1}));C=[{colourName:"green",isSubtle:false}];equal(D.getBackgroundColour.callCount,1,"StatusLozengeColours.getBackgroundColour was called");deepEqual(D.getBackgroundColour.args[0],C,"It was passed the correct arguments");equal(D.getBorderColour.callCount,0,"StatusLozengeColours.getBorderColour wasn't called");equal(D.getColour.callCount,1,"StatusLozengeColours.getColour was called");deepEqual(D.getColour.args[0],C,"It was passed the correct arguments");equal(A._figure.getBackgroundColor().hash(),"#FF0000","The current status has the correct background colour");equal(A._figure.getColor().hash(),"#FFFFFF","The current status has the correct border colour");equal(A._figure.getTextColor().hash(),"#0000FF","The current status has the correct text colour");B=this.canvasView.addStatus(new JIRA.WorkflowDesigner.StatusModel({statusCategory:{colourName:"yellow",id:2},stepId:2}));C=[{colourName:"yellow",isSubtle:true}];equal(D.getBackgroundColour.callCount,2,"StatusLozengeColours.getBackgroundColour was called");deepEqual(D.getBackgroundColour.args[1],C,"It was passed the correct arguments");equal(D.getBorderColour.callCount,1,"StatusLozengeColours.getBorderColour was called");deepEqual(D.getBorderColour.args[0],C,"It was passed the correct arguments");equal(D.getColour.callCount,2,"StatusLozengeColours.getColour was called");deepEqual(D.getColour.args[1],C,"It was passed the correct arguments");equal(B._figure.getBackgroundColor().hash(),"#FF0000","The current status has the correct background colour");equal(B._figure.getColor().hash(),"#00FF00","The current status has the correct border colour");equal(B._figure.getTextColor().hash(),"#0000FF","The current status has the correct text colour")});test("Statuses are the correct colour when status lozenges aren't available in subtle mode",function(){var A,B;this.canvasView=JIRA.WorkflowDesigner.TestUtilities.testCanvasView({workflowModel:new JIRA.WorkflowDesigner.WorkflowModel({currentStepId:1})});A=this.canvasView.addStatus(new JIRA.WorkflowDesigner.StatusModel({stepId:1}));equal(A._figure.getBackgroundColor().hash(),"#4A6785","The current status has the correct background colour");equal(A._figure.getColor().hash(),"#FFFFFF","The current status has the correct border colour");equal(A._figure.getTextColor().hash(),"#FFFFFF","The current status has the correct text colour");B=this.canvasView.addStatus(new JIRA.WorkflowDesigner.StatusModel({stepId:2}));equal(B._figure.getBackgroundColor().hash(),"#FFFFFF","The other status has the correct background colour");equal(B._figure.getColor().hash(),"#4A6785","The other status has the correct border colour");equal(B._figure.getTextColor().hash(),"#4A6785","The other status has the correct text colour")});test('The figure is added to the "selected-status" layer on selection',function(){var C=this.canvas.getLayer("selected-status"),B=this.canvas.getLayer("statuses"),A=this.createStatusView();sinon.spy(C,"addFigure");sinon.spy(B,"addFigure");A.select();equal(C.addFigure.callCount,1,'The "selected-status" layer\'s #addFigure() method was called');ok(C.addFigure.args[0][0]===A._figure,"It was passed the correct figure");A.deselect();equal(B.addFigure.callCount,1,'The "statuses" layer\'s #addFigure() method was called');ok(B.addFigure.args[0][0]===A._figure,"It was passed the correct figure")});test('The figure is added to the "statuses" layer',function(){var B=this.canvas.getLayer("statuses"),A;sinon.spy(B,"addFigure");A=this.createStatusView();equal(B.addFigure.callCount,1,'The "statuses" layer\'s #addFigure() method was called');ok(B.addFigure.args[0][0]===A._figure,"It was passed the correct figure")});