AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Dialogs.AddTransitionDialogView",{createWorkflowModel:function(){var A;A=new JIRA.WorkflowDesigner.WorkflowModel();A.get("statuses").add([{name:"Open",stepId:1},{name:"In Progress",stepId:2},{name:"Closed",stepId:3}]);return A},setup:function(){var A=this.sandbox=sinon.sandbox.create();this.getScreensDeferred=jQuery.Deferred().resolve([]);this.getScreensStub=A.stub(JIRA.WorkflowDesigner.IO.AJAX.ScreensAJAXManager,"getScreens").returns(this.getScreensDeferred);this.newTransitionFormViewSpy=this.sandbox.spy(JIRA.WorkflowDesigner,"NewTransitionFormView");this.newTransitionFormViewSubmitDeferred=jQuery.Deferred();this.newTransitionFormViewSubmitStub=this.sandbox.stub(JIRA.WorkflowDesigner.NewTransitionFormView.prototype,"submit").returns(this.newTransitionFormViewSubmitDeferred);this.reuseTransitionFormViewSpy=A.spy(JIRA.WorkflowDesigner,"ReuseTransitionFormView");this.reuseTransitionFormViewSubmitDeferred=jQuery.Deferred();this.reuseTransitionFormViewSubmitStub=this.sandbox.stub(JIRA.WorkflowDesigner.ReuseTransitionFormView.prototype,"submit").returns(this.reuseTransitionFormViewSubmitDeferred);this.showErrorMessageSpy=this.sandbox.spy(JIRA.WorkflowDesigner.Dialogs.AddTransitionDialogView.prototype,"showErrorMessage")},showDialog:function(A){A=_.defaults({},A,{transitionModel:new JIRA.WorkflowDesigner.TransitionModel(),workflowModel:this.createWorkflowModel()});A.canvasModel||(A.canvasModel=new JIRA.WorkflowDesigner.CanvasModel({},{workflowModel:A.workflowModel}));return new JIRA.WorkflowDesigner.Dialogs.AddTransitionDialogView(A).show()},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});test("Automatically selects the transition's source and target statuses",function(){var C,A,D,B;B=this.createWorkflowModel();D=B.get("statuses");this.showDialog({transitionModel:new JIRA.WorkflowDesigner.TransitionModel({source:D.at(1),target:D.at(2)})});C=this.newTransitionFormViewSpy.thisValues[0];equal(C.ui.sourceStepId.val(),2,"The transition's source is selected");equal(C.ui.targetStepId.val(),3,"The transition's target is selected");A=this.reuseTransitionFormViewSpy.thisValues[0];equal(A.ui.sourceStepId.val(),2,"The transition's source is selected");equal(A.ui.targetStepId.val(),3,"The transition's target is selected")});test("Creates and shows a NewTransitionFormView and a ReuseTransitionFormView",function(){var C=this.showDialog(),B,A,D;D=[{selected:false,text:"Closed",value:3},{selected:false,text:"In Progress",value:2},{selected:false,text:"Open",value:1}];B={model:C.options.transitionModel,screens:[],sourceStatuses:D,targetStatuses:D,workflowModel:C.options.workflowModel};ok(this.newTransitionFormViewSpy.calledWithExactly(B),"A NewTransitionFormView was created");ok(C.newTransitionPane.currentView===this.newTransitionFormViewSpy.thisValues[0],"It was shown in the newTransitionPane region");A=_.omit(B,"screens");ok(this.reuseTransitionFormViewSpy.calledWithExactly(A),"A ReuseTransitionFormView was created");ok(C.reuseTransitionPane.currentView===this.reuseTransitionFormViewSpy.thisValues[0],"It was shown in the reuseTransitionPane region")});test("Doesn't show the initial status in the status fields",function(){var A;A=this.createWorkflowModel();A.get("statuses").reset([{initial:true}]);this.showDialog({workflowModel:A});deepEqual(this.newTransitionFormViewSpy.args[0][0].sourceStatuses,[],"No source statuses were passed to NewTransitionFormView");deepEqual(this.newTransitionFormViewSpy.args[0][0].targetStatuses,[],"No target statuses were passed to NewTransitionFormView");deepEqual(this.reuseTransitionFormViewSpy.args[0][0].sourceStatuses,[],"No source statuses were passed to ReuseTransitionFormView");deepEqual(this.reuseTransitionFormViewSpy.args[0][0].targetStatuses,[],"No target statuses were passed to ReuseTransitionFormView")});test("Failing to create a new transition",function(){var A;A=this.showDialog();A.$("form").submit();this.newTransitionFormViewSubmitDeferred.reject("Nope");equal(A.$(":input:disabled").length,0,"All inputs are enabled");ok(this.showErrorMessageSpy.calledWithExactly("Nope"),"The correct error message was shown")});test("Failing to reuse a transition",function(){var A;A=this.showDialog();AJS.tabs.change(A.$(".aui-tabs a:last"));A.$("form").submit();this.reuseTransitionFormViewSubmitDeferred.reject("Nope");equal(A.$(":input:disabled").length,0,"All inputs are enabled");ok(this.showErrorMessageSpy.calledWithExactly("Nope"),"The correct error message was shown")});test("Hides and shows an error message when loading screen information fails",function(){var B,C,A;C=jQuery.Deferred();A=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage");this.getScreensStub.returns(C);B=this.showDialog();C.reject("Error");ok(B.$el.is(":hidden"),"The dialog isn't visible");ok(A.calledWithExactly("Error"),"showErrorMessage was called with the correct error message")});test("Repositions on tab change",function(){var B,A;B=this.showDialog();A=this.sandbox.spy(JIRA.WorkflowDesigner.Dialogs.FormDialogView.prototype,"reposition");B.$(".aui-tabs a:last").click();equal(A.callCount,1,"FormDialogView#reposition was called")});test("Requests screen information on show",function(){var A,B;B=jQuery.Deferred();this.getScreensStub.returns(B);A=this.showDialog();ok(A.$el.is(":hidden"),"The dialog isn't visible");B.resolve([]);ok(A.$el.is(":visible"),"The dialog is visible")});test("Shows the new transition pane when ReuseTransitionFormView triggers a createNewTransition event",function(){var C,B,A,D;C=this.showDialog();B=C.$(".aui-tabs .new-transition > a");D=this.sandbox.spy(AJS.tabs,"change");A=this.reuseTransitionFormViewSpy.thisValues[0];A.trigger("createNewTransition");ok(D.calledWithExactly(B),"The new transition pane was shown")});test("Successfully creates a new transition",function(){var B=this.showDialog(),A=B.options.transitionModel;B.$("form").submit();equal(B.$(":input:disabled").length,B.$(":input").length,"All inputs are disabled");equal(this.newTransitionFormViewSubmitStub.callCount,1,"NewTransitionFormView#submit was called");this.newTransitionFormViewSubmitDeferred.resolve();ok(B.options.canvasModel.get("selectedModel")===A,"The TransitionModel is selected");ok(B.options.workflowModel.get("transitions").contains(A),"The TransitionModel was added to the WorkflowModel's transitions collection");ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog was hidden")});test("Successfully reuses an existing transition",function(){var B=this.showDialog(),A=B.options.transitionModel;AJS.tabs.change(B.$(".aui-tabs a:last"));B.$("form").submit();equal(B.$(":input:disabled").length,B.$(":input").length,"All inputs are disabled");equal(this.reuseTransitionFormViewSubmitStub.callCount,1,"ReuseTransitionFormView#submit was called");this.reuseTransitionFormViewSubmitDeferred.resolve();ok(B.options.canvasModel.get("selectedModel")===A,"The TransitionModel is selected");ok(B.options.workflowModel.get("transitions").contains(A),"The TransitionModel was added to the WorkflowModel's transitions collection");ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog was hidden")});