(function (Backbone) {
    /**
     * @class JIRA.WorkflowDesigner.Dialogs.EditGlobalTransitionDialogView
     * @classdesc The workflow designer's "Edit Global Transition" dialog.
     * @extends JIRA.WorkflowDesigner.Dialogs.TransitionDialogView
     */
    Backbone.define("JIRA.WorkflowDesigner.Dialogs.EditGlobalTransitionDialogView", JIRA.WorkflowDesigner.Dialogs.EditTransitionDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.EditGlobalTransitionDialogView# */
    {
        id: "edit-global-transition-dialog",

        /**
         * Make a request to update the global transition.
         *
         * @return {jQuery.Deferred} A deferred that is resolved on success.
         * @private
         */
        _makeRequest: function (options) {
            return JIRA.WorkflowDesigner.IO.AJAX.WorkflowGlobalTransitionsAJAXManager.updateGlobalTransition(options);
        },

        /**
         * Trigger an analytics event indicating that the update was successful.
         *
         * @protected
         */
        _triggerAnalyticsEvent: function () {
            JIRA.WorkflowDesigner.Analytics.triggerUpdateGlobalTransition();
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));