AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:dialog");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");

module("JIRA.WorkflowDesigner.Dialog", {
    setup: function () {
        this.sandbox = sinon.sandbox.create();
        JIRA.WorkflowDesigner.TestMocks.application(this.sandbox);
    },

    teardown: function () {
        JIRA.WorkflowDesigner.TestUtilities.removeDialogs();
        this.sandbox.restore();
    },

    showDialog: function() {
        new JIRA.WorkflowDesigner.Dialog({
            id: "workflow-dialog",
            workflowId: function() {
                return "workflow";
            },
            currentStepId: function() {
                return "1";
            }
        }).show();
    },

    /**
     * @return {boolean} Whether the dialog blanket is visible.
     */
    blanketIsVisible: function () {
        return !!jQuery(".aui-blanket:visible").length;
    },

    /**
     * @return {boolean} Whether any dialog is visible.
     */
    dialogIsVisible: function () {
        return !!(JIRA.Dialog.current || jQuery(".jira-dialog:visible").length);
    },

    /**
     * @return {boolean} Whether the dialog contains the passed element (given as jQuery object or selector).
     */
    dialogContains: function(element) {
        var container = JIRA.Dialog.current.get$popup()[0],
            contained = jQuery(element)[0];

        return jQuery.contains(container, contained);
    }
});

test("Dialog contains the workflow designer", function () {
    var actualArguments,
        applicationStub = JIRA.WorkflowDesigner.Application,
        expectedArguments;

    this.showDialog();
    ok(this.blanketIsVisible(), "The screen is dimmed");
    ok(this.dialogIsVisible(), "The dialog is visible");

    actualArguments = applicationStub.args[0][0];
    expectedArguments = {
        actions: false,
        currentStepId: "1",
        draft: false,
        immutable: true,
        workflowId: "workflow"
    };

    equal(applicationStub.callCount, 1, "A JIRA.WorkflowDesigner.Application instance was created");
    ok(this.dialogContains(actualArguments.element), "The designer is shown in the dialog");
    deepEqual(_.pick(actualArguments, _.keys(expectedArguments)), expectedArguments,
            "It was passed the correct arguments");
});

test("Dialog has a label mouse-over hint in the footer", function () {
    this.showDialog();

    ok(this.dialogContains(".buttons-container-left"), "The dialog footer contains a hint message");
});

test("Dialog height and width are adjusted to fit window", function () {
    var sizingStub = this.sandbox.stub(JIRA.WorkflowDesigner.DialogSizeCalculator, "calculateDialogSize", function(){
        return {
            height: 200,
            width: 200
        };
    });

    this.showDialog();

    equal(jQuery("#workflow-dialog").width(), 200, "Dialog width is set as per sizing function");
    equal(jQuery("#workflow-dialog .form-body").height(), 200, "Dialog height is set as per sizing function");
    ok(sizingStub.called);
});

test("Dialog resize function is called when dialog displayed", function () {
    var dialogSpy = this.sandbox.spy(JIRA.WorkflowDesigner.Dialog.prototype, "_sizeAndPositionDialog");

    this.showDialog();

    equal(dialogSpy.callCount, 1, "The dialog is resized when displayed.");
});

test("Dialog resize function is called when window is resized", function () {
    var dialogSpy = this.sandbox.spy(JIRA.WorkflowDesigner.Dialog.prototype, "_sizeAndPositionDialog");

    this.showDialog();
    jQuery(window).trigger("resize");

    equal(dialogSpy.callCount, 2, "The dialog is resized when the window is resized.");
});