(function (Backbone) {
    Backbone.define("JIRA.WorkflowDesigner.Dialogs.DeleteTransitionDialogView", JIRA.WorkflowDesigner.Dialogs.FormDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.DeleteTransitionDialogView# */
    {
        id: "delete-transition-dialog",

        /**
         * Initialise the view.
         *
         * @constructs
         * @classdesc The workflow designer's "Delete transition" dialog.
         * @extends JIRA.WorkflowDesigner.Dialogs.FormDialogView
         * @param {object} options
         * @param {JIRA.WorkflowDesigner.TransitionModel} options.transitionModel The transition model to destroy.
         * @param {JIRA.WorkflowDesigner.WorkflowModel} options.workflowModel The application's workflow model.
         */
        initialize: function (options) {
            _.bindAll(this, "_onError", "_onSuccess");

            this.transitionModel = options.transitionModel;
            this.workflowModel = options.workflowModel;
        },

        /**
         * @returns {jQuery} Content of the dialog
         * @private
         */
        _getContent: function () {
            var template = this._chooseContentTemplate();
            return jQuery(template({
                transitionName: this.transitionModel.get("name")
            }));
        },

        /**
         * @returns {function} Template used for the content
         * @private
         */
        _chooseContentTemplate: function() {
            if (this.transitionModel.isInitial()) {
                return JIRA.WorkflowDesigner.Templates.cannotDeleteInitialTransitionDialog;
            }

            return JIRA.WorkflowDesigner.Templates.confirmDeleteTransitionDialog;
        },

        /**
         * @param {jQuery.Event} e Submit event
         * @param {function} callback Function to call when this event has been handled
         * @private
         */
        _onSubmit: function (e, callback) {
            var options, request;

            e.preventDefault();
            this.disable();
            this.removeErrorMessages();

            options = {
                transitionId: this.transitionModel.get("actionId"),
                sourceStepId: this.transitionModel.getSourceStepId(),
                workflowName: this.workflowModel.get("name")
            };

            request = this.transitionModel.isGlobalTransition() ?
                JIRA.WorkflowDesigner.IO.AJAX.WorkflowGlobalTransitionsAJAXManager.deleteGlobalTransition(options) :
                JIRA.WorkflowDesigner.IO.AJAX.WorkflowTransitionsAJAXManager.deleteTransition(options);

            request.done(this._onSuccess).fail(callback).fail(this._onError);
        },

        /**
         * @private
         */
        _onSuccess: function () {
            this.transitionModel.isGlobalTransition() ?
                JIRA.WorkflowDesigner.Analytics.triggerRemoveGlobalTransition() :
                JIRA.WorkflowDesigner.Analytics.triggerRemoveTransition();

            this.hide();
            this.transitionModel.destroy();
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));