AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.ZoomHandler", {
    /**
     * Trigger a Firefox scroll event.
     *
     * @param {number} delta The scroll distance.
     * @param {element} target The target element.
     */
    scrollFirefox: function (delta, target) {
        jQuery(document).trigger(new jQuery.Event("MozMousePixelScroll", {
            altKey: true,
            originalEvent: {
                detail: delta,
                clientX: 0,
                clientY: 0
            },
            target: jQuery(target)[0]
        }));
    },

    /**
     * Trigger a non-Firefox scroll event.
     *
     * @param {number} delta The scroll distance.
     * @param {element} target The target element.
     */
    scrollOtherBrowsers: function (delta, target) {
        jQuery(document).trigger(new jQuery.Event("mousewheel", {
            altKey: true,
            originalEvent: {
                clientX: 0,
                clientY: 0,
                wheelDeltaY: delta
            },
            target: jQuery(target)[0]
        }));
    },

    setup: function () {
        this.canvas = jQuery("<div>").appendTo("#qunit-fixture");
        this.zoomHandler = new JIRA.WorkflowDesigner.ZoomHandler(this.canvas);
        this.zoomSpy = sinon.spy();

        this.zoomHandler.on("zoom", this.zoomSpy);
    },

    teardown: function () {
        this.zoomHandler.destroy();
    }
});

test("Triggers zoom events (non-Firefox)", function () {
    var tests;

    tests = [
        [-250, this.canvas, 1.50],
        [ -25, this.canvas, 1.05],
        [   0, this.canvas, 1.00],
        [  25, this.canvas, 0.95],
        [ 250, this.canvas, 0.50],
        [1000, this.canvas, 0.10]
    ];

    _.each(tests, function (test, index) {
        this.scrollOtherBrowsers.apply(this, test);
        equal(this.zoomSpy.callCount, index + 1, "A zoom event was triggered");
        equal(this.zoomSpy.lastCall.args[0].factor, test[2], "Its zoom factor was correct");
    }, this);
});

test("Triggers zoom events (Firefox)", function () {
    var tests;

    tests = [
        [-40, this.canvas, 0.800],
        [-10, this.canvas, 0.950],
        [ -1, this.canvas, 0.995],
        [  0, this.canvas, 1.000],
        [  1, this.canvas, 1.005],
        [ 10, this.canvas, 1.050]
    ];

    _.each(tests, function (test, index) {
        this.scrollFirefox.apply(this, test);
        equal(this.zoomSpy.callCount, index + 1, "A zoom event was triggered");
        equal(this.zoomSpy.lastCall.args[0].factor, test[2], "Its zoom factor was correct");
    }, this);
});

test("Triggers zoom events when the cursor is over a descendant of the canvas", function () {
    this.scrollOtherBrowsers(1, jQuery("<div>").appendTo(this.canvas));
    equal(this.zoomSpy.callCount, 1, "A zoom event was triggered");
});

test("Doesn't trigger a zoom event if the cursor isn't over the canvas", function () {
    this.scrollOtherBrowsers(1, jQuery("body"));
    equal(this.zoomSpy.callCount, 0, "No zoom event was triggered");
});

test("Doesn't trigger a zoom event if the modifier key isn't pressed", function () {
    jQuery(document).trigger(new jQuery.Event("mousewheel", {
        altKey: false,
        originalEvent: {
            clientX: 0,
            clientY: 0,
            wheelDeltaY: 0
        },
        target: this.canvas[0]
    }));

    equal(this.zoomSpy.callCount, 0, "No zoom event was triggered");
});

test("Horizontal scroll isn't included in the zoom factor (non-Firefox)", function () {
    jQuery(document).trigger(new jQuery.Event("mousewheel", {
        altKey: true,
        originalEvent: {
            clientX: 0,
            clientY: 0,
            wheelDelta: 1,
            wheelDeltaX: 1,
            wheelDeltaY: 0
        },
        target: this.canvas[0]
    }));

    equal(this.zoomSpy.callCount, 1, "A zoom event was triggered");
    equal(this.zoomSpy.args[0][0].factor, 1, "Its zoom factor was correct");
});

test("Horizontal scroll isn't included in the zoom factor (Firefox)", function () {
    var horizontal = 1,
        vertical = 2;

    jQuery(document).trigger(new jQuery.Event("MozMousePixelScroll", {
        altKey: true,
        originalEvent: {
            axis: horizontal,
            clientX: 0,
            clientY: 0,
            detail: 1,
            HORIZONTAL_AXIS: horizontal,
            VERTICAL_AXIS: vertical
        },
        target: this.canvas[0]
    }));

    equal(this.zoomSpy.callCount, 1, "A zoom event was triggered");
    equal(this.zoomSpy.args[0][0].factor, 1, "Its zoom factor was correct");
});