(function(A){A.define("JIRA.WorkflowDesigner.CanvasView",A.View.extend({className:"canvas",initialize:function(B){_.bindAll(this,"_onKeyDown");B=_.defaults({},B,{immutable:false});this._canvasModel=B.canvasModel;this.immutable=B.immutable;this.statusViews=new JIRA.WorkflowDesigner.Collection();this.transitionViews=new JIRA.WorkflowDesigner.Collection();this._workflowModel=B.workflowModel;this._zoomHandler=new JIRA.WorkflowDesigner.ZoomHandler(this.el);this.immutable||jQuery(document).on("keydown",this._onKeyDown);this.listenTo(this._canvasModel,"change:selectedModel",this._onSelectedModelChange);this.listenTo(this.statusViews,{deselected:this._clearSelectedView,"port:drag:end":this._onPortDragEnd,"port:drag:start":_.bind(this._setPortDragged,this,true),selected:this._setSelectedView});this.listenTo(this.transitionViews,{deselected:this._onTransitionDeselected,reconnect:this._onReconnect,selected:this._onTransitionSelected});this.listenTo(this._workflowModel,"reset:after",this._positionNewStatuses);this.listenTo(this._workflowModel.get("statuses"),{add:this.addStatus,remove:this.removeStatus,reset:this.resetStatuses});this.listenTo(this._workflowModel.get("transitions"),{add:this.addTransition,"change:source change:target":this._updateTransitionSourceAndTarget,remove:this.removeTransition,reset:this.resetTransitions});this.listenTo(this._zoomHandler,"zoom",this._onZoom)},addStatus:function(C){var F=C.get("initial"),D=this._canvasModel.get("selectedModel")===C,B,E;if(F){E=JIRA.WorkflowDesigner.InitialStatusView}else{E=JIRA.WorkflowDesigner.StatusView}B=new E({canvas:this.canvas,getAllTargetPorts:_.bind(this._getAllTargetPorts,this),immutable:this.immutable,isPortDragged:_.bind(this._isPortDragged,this),model:C,workflowModel:this._workflowModel}).render();this.statusViews.add(B);D&&B.select();return B},addTransition:function(B){var F=B.get("globalTransition"),C=this._canvasModel.get("selectedModel")===B,D=this._getTransitionViewWithModel(B),E;if(D){return D}if(F){E=JIRA.WorkflowDesigner.GlobalTransitionView}else{E=JIRA.WorkflowDesigner.TransitionView}D=new E({canvas:this.canvas,canvasModel:this._canvasModel,immutable:this.immutable,model:B,sourceView:this._getStatusViewWithModel(B.get("source")),targetView:this._getStatusViewWithModel(B.get("target")),workflowModel:this._workflowModel});D.requestResponse&&D.requestResponse.setHandler("isSelected",this._transitionIsSelected,this);D.render();this.transitionViews.add(D);C&&D.select();return D},autoFit:function(){var B,E,C,D=10,F;this.canvas.fitToContainer();B=this.getCanvasBoundingBox();if(B){B.scale(D*2,D*2);F=new draw2d.geo.Rectangle(0,0,this.$el.width(),this.$el.height());C=B.getHeight()<=F.getHeight()&&B.getWidth()<=F.getWidth();if(!C){this.canvas.setViewBox(B);F=this.canvas.getViewBox()}E=B.getCenter();this.canvas.setViewBox(new draw2d.geo.Rectangle(E.getX()-F.getWidth()/2,E.getY()-F.getHeight()/2,F.getWidth(),F.getHeight()));this._canvasModel.set("zoomLevel",this.canvas.getZoom())}},_clearSelectedView:function(B){var C=this._canvasModel.get("selectedView")===B;C&&this._canvasModel.selectView(null)},_createCanvas:function(B){var C,D=_.bind(this.getCanvasBoundingBox,this),F=this._getUniqueId(),E;B=jQuery(B);B.append(this.el);this.$el.attr("id",F);E=["statuses","selected-status","transitions","global-transitions","highlighted-transition","selected-transition","transition-labels"];C=new JIRA.WorkflowDesigner.Draw2DCanvas(F);C.createLayers(E);C.installEditPolicy(new JIRA.WorkflowDesigner.Policy.Canvas.PanningSingleSelectionPolicy(D));C.installEditPolicy(new JIRA.WorkflowDesigner.Policy.Canvas.SnapToGeometry.SnapEditPolicy());C.installEditPolicy(new JIRA.WorkflowDesigner.Policy.Canvas.SnapToGeometry.GuideLineEditPolicy());C.onNewConnection=_.bind(this._onNewConnection,this);return C},_delete:function(){var B=this._canvasModel.get("selectedView");B&&B.destroy();return !!B},_getAllTargetPorts:function(){function C(D){return D.model.isInitial()}function B(D){return D.getPorts()}return this.statusViews.chain().reject(C).flatMap(B).value()},getCanvasBoundingBox:function(){var C,E=this.canvas.getFigures().asArray(),B=this.canvas.getLines().asArray();function D(G){var H=G.getBoundingBox();if(C){C=C.union(H)}else{C=H}}function F(G){return G instanceof JIRA.WorkflowDesigner.Draw2DCanvas.LayerRootFigure}_.chain(E).reject(F).each(D);_.each(B,D);return C},_getSiblingTransitions:function(B){var D=B.model.get("actionId");function C(E){return E.model.get("actionId")===D}return this.transitionViews.chain().filter(C).without(B).value()},_getStatusViewWithModel:function(B){return this.statusViews.find(function(C){return C.model===B})},getStatusViewWithPort:function(B){return this.statusViews.find(function(C){return _.contains(C.getPorts(),B)})},_getTransitionViewWithModel:function(B){return this.transitionViews.find(function(C){return C.model===B})},_getUniqueId:function(){var B=0,C;do{B++;C="workflow-designer"+B}while(jQuery("#"+C).length);return C},_isPortDragged:function(){return !!this.portDragged},_onKeyDown:function(B){if(this._shouldHandleDelete(B)){this._delete()&&B.preventDefault()}},_onNewConnection:function(D){var C=D.getSource(),B=this.getStatusViewWithPort(C),F=D.getTarget(),E=this.getStatusViewWithPort(F),G;G=new JIRA.WorkflowDesigner.TransitionModel({source:B.model,sourceAngle:B.getAngleToPort(C),target:E.model,targetAngle:E.getAngleToPort(F)});this.canvas.removeFigure(D);new JIRA.WorkflowDesigner.Dialogs.AddTransitionDialogView({canvasModel:this._canvasModel,transitionModel:G,workflowModel:this._workflowModel}).show()},_onReconnect:function(F){var H,C=F.getConnection().getSource(),B=this.getStatusViewWithPort(C),G,E=F.getConnection().getTarget(),D=this.getStatusViewWithPort(E);H=B.model!==F.model.get("source");G=D.model!==F.model.get("target");if(H){new JIRA.WorkflowDesigner.Dialogs.EditTransitionSourceDialogView({newSourcePort:C,newSourceView:B,originalSourceStatus:F.model.get("source"),transitionView:F,workflowModel:this._workflowModel}).show()}else{if(G){new JIRA.WorkflowDesigner.Dialogs.EditTransitionTargetDialogView({targetPort:E,targetView:D,transitionView:F,workflowModel:this._workflowModel}).show()}else{F.model.set({source:B.model,sourceAngle:B.getAngleToPort(C),target:D.model,targetAngle:D.getAngleToPort(E)})}}},_onTransitionDeselected:function(B){this._clearSelectedView(B);_.invoke(this._getSiblingTransitions(B),"unhighlight")},_onTransitionSelected:function(B){this._setSelectedView(B);_.invoke(this._getSiblingTransitions(B),"appearSelected")},_onZoom:function(B){AJS.InlineDialog.current&&AJS.InlineDialog.current.hide();this.zoom(B.factor,this.canvas.fromDocumentToCanvasCoordinate(B.clientX,B.clientY))},_positionNewStatuses:function(){var B=this._workflowModel.get("statuses").map(this._getStatusViewWithModel,this);JIRA.WorkflowDesigner.StatusPositioner.positionStatuses(B,this.canvas.getViewBox())},remove:function(){A.View.prototype.remove.apply(this,arguments);jQuery(document).off("keydown",this._onKeyDown);this._zoomHandler.destroy()},removeStatus:function(C){var B=this._getStatusViewWithModel(C);if(B){B.remove();this.statusViews.remove(B)}},removeTransition:function(B){var C=this._getTransitionViewWithModel(B);if(C){C.remove();this.transitionViews.remove(C)}},render:function(B){this.canvas||(this.canvas=this._createCanvas(B));return this},resetStatuses:function(){while(this.statusViews.length){this.removeStatus(this.statusViews.at(0).model)}this._workflowModel.get("statuses").each(function(B){this.addStatus(B)},this)},resetTransitions:function(){while(this.transitionViews.length){this.removeTransition(this.transitionViews.at(0).model)}this._workflowModel.get("transitions").forEach(function(B){this.addTransition(B)},this)},_transitionIsSelected:function(D){var F=D.model.get("actionId"),C=this._canvasModel.get("selectedView")===D,B=this._canvasModel.get("selectedModel"),E=!!B&&B.get("actionId")===F;return C||E},_onSelectedModelChange:function(E,B){var D=this._getStatusViewWithModel(B)||this._getTransitionViewWithModel(B),C=this._canvasModel.get("selectedView");if(B&&D&&D!==C){D.select()}},_onPortDragEnd:function(){function B(C){return C.model.isInitial()}this._setPortDragged(false);this.statusViews.chain().reject(B).invoke("updatePortsVisibility")},setLocked:function(B){this._isLocked=B},_setPortDragged:function(B){this.portDragged=B},setResizeInterval:function(B){this.canvas.setResizeInterval(B)},_setSelectedView:function(B){this._canvasModel.selectView(B)},_shouldHandleDelete:function(E){var B=[jQuery.ui.keyCode.BACKSPACE,jQuery.ui.keyCode.DELETE],F=!!jQuery(".aui-blanket:visible").length,D=_.contains(B,E.which),C=jQuery(E.target).is(":input");return !F&&D&&!C&&!this._isLocked},_updateTransitionSourceAndTarget:function(C){var B=this._getStatusViewWithModel(C.get("source")),D=this._getStatusViewWithModel(C.get("target")),E=this._getTransitionViewWithModel(C);E.setViews(B,D);E.resetConnection()},zoom:function(B,C){this.canvas.zoom(B,C||this.canvas.getViewBox().getCenter(),this.getCanvasBoundingBox());this._canvasModel.set("zoomLevel",this.canvas.getZoom())}}))}(JIRA.WorkflowDesigner.Backbone));