AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:view-issue-page-workflow-designer");

module("JIRA.WorkflowDesigner.ViewIssue", {
    setup: function () {
        this.sandbox = sinon.sandbox.create();
    },

    teardown: function () {
        JIRA.WorkflowDesigner.TestUtilities.removeDialogs();
        this.sandbox.restore();
    }
});

test("Failing to load layout data", function () {
    var loadStub = this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager, "load"),
        showErrorMessageStub = this.sandbox.stub(JIRA.WorkflowDesigner.Messages, "showErrorMessage"),
        trigger = jQuery("<a class='issueaction-viewworkflow new-workflow-designer' href='javascript:'></a>").appendTo("#qunit-fixture");

    // Clicking the "View Workflow" link should show an error message
    // saying that the workflow's layout information couldn't be loaded.
    loadStub.returns(jQuery.Deferred().reject());
    trigger.click();

    equal(showErrorMessageStub.callCount, 1, "An error message was displayed");
    equal(jQuery(".aui-blanket:visible").length, 0, "The screen is not dimmed");
    equal(JIRA.Dialog.current, null, "No dialog is visible");
});

test("JIRA.Events.NEW_CONTENT_ADDED integration", function () {
    var browserIsSupportedStub = this.sandbox.stub(JIRA.WorkflowDesigner, "browserIsSupported"),
        element = jQuery("<div/>"),
        replaceViewWorkflowLinkSpy = this.sandbox.spy(JIRA.WorkflowDesigner.ViewIssue, "replaceViewWorkflowLink");

    JIRA.trigger(JIRA.Events.NEW_CONTENT_ADDED, [element]);
    equal(browserIsSupportedStub.callCount, 1, "Triggering NEW_CONTENT_ADDED invokes the view issue logic");
    equal(replaceViewWorkflowLinkSpy.callCount, 0, "The \"View Workflow\" link isn't patched if browserIsSupported returns false");

    browserIsSupportedStub.returns(true);
    JIRA.trigger(JIRA.Events.NEW_CONTENT_ADDED, [element]);
    equal(browserIsSupportedStub.callCount, 2, "Triggering NEW_CONTENT_ADDED invokes the view issue logic");
    equal(replaceViewWorkflowLinkSpy.callCount, 1, "The \"View Workflow\" link is patched if browserIsSupported returns true");
});

test("replaceViewWorkflowLink()", function () {
    var applicationStub = JIRA.WorkflowDesigner.TestMocks.application(this.sandbox),
        context,
        loadStub = this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager, "load"),
        newWorkflowLink,
        oldWorkflowLink,
        replaceViewWorkflowLink = JIRA.WorkflowDesigner.ViewIssue.replaceViewWorkflowLink,
        workflowImageURL = "?stepId=42&workflowName=Workflow+Name";

    context = jQuery("<div><a>View Workflow</a></div>").appendTo("#qunit-fixture");
    oldWorkflowLink = context.find("a")
            .addClass("issueaction-viewworkflow")
            .attr("href", workflowImageURL);

    replaceViewWorkflowLink(context);
    equal(oldWorkflowLink.closest("div").length, 0, "The old workflow link is removed");

    newWorkflowLink = context.find("a");
    equal(newWorkflowLink.attr("href"), workflowImageURL, "The new workflow link's href attribute is correct");
    ok(newWorkflowLink.hasClass("issueaction-viewworkflow"), "The new workflow link has the issueaction-viewworkflow class");

    replaceViewWorkflowLink(context);
    ok(context.has(newWorkflowLink), "Running replaceViewWorkflowLink() multiple times does nothing");

    loadStub.returns(jQuery.Deferred().resolve());
    newWorkflowLink.click();
    ok(loadStub.callCount === 1 && loadStub.args[0][0] === "Workflow Name", "The correct workflow name was parsed");
    ok(applicationStub.callCount === 1 && applicationStub.args[0][0].currentStepId === 42, "The correct step ID was parsed");
});

test("View workflow dialog", function () {
    var applicationOptions,
        applicationStub = JIRA.WorkflowDesigner.TestMocks.application(this.sandbox),
        layoutData = {},
        loadStub = this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager, "load"),
        trigger = jQuery("<a class='issueaction-viewworkflow new-workflow-designer' href='javascript:'></a>").appendTo("#qunit-fixture");

    // Clicking the "View Workflow" link should show the workflow dialog.
    loadStub.returns(jQuery.Deferred().resolve(layoutData));
    trigger.click();

    ok(JIRA.Dialog.current !== null, "A dialog is visible");
    equal(applicationStub.callCount, 1, "A workflow designer was created");

    applicationOptions = applicationStub.args[0][0];
    ok(JIRA.Dialog.current.get$popup().has(applicationOptions.element).length, "It is shown in the dialog");
    ok(applicationOptions.immutable, "It is immutable");
});