AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.StatusPositioner", {
    mockStatusView: JIRA.WorkflowDesigner.TestMocks.statusView,

    setup: function () {
        this.positionStatuses = JIRA.WorkflowDesigner.StatusPositioner.positionStatuses;
        this.viewBox = new draw2d.geo.Rectangle(0, 0, 1000, 1000);
    }
});

test("positionStatuses() calculates the correct positions", function () {
    var statuses = [
        this.mockStatusView([100,  50]),
        this.mockStatusView([ 50, 100]),
        this.mockStatusView([100,  50])
    ];

    this.positionStatuses(statuses, this.viewBox);
    deepEqual(statuses[0].setPosition.args[0], [450, 100], "The first view was positioned correctly");
    deepEqual(statuses[1].setPosition.args[0], [475, 150], "The second view was positioned correctly");
    deepEqual(statuses[2].setPosition.args[0], [450, 250], "The third view was positioned correctly");
});

test("positionStatuses() only positions statuses without coordinates", function () {
    var statuses = [
        this.mockStatusView([100, 50]),
        this.mockStatusView([100, 50], [0, 0])
    ];

    this.positionStatuses(statuses, this.viewBox);
    equal(statuses[0].setPosition.callCount, 1, "The first view was positioned");
    equal(statuses[1].setPosition.callCount, 0, "The second view was not positioned");
});