(function () {
    _.mixin({
        /**
         * Calculate the cartesian product of any number of arrays.
         * <pre>
         * &gt; _.cartesianProduct([1, 2], [3, 4]);
         * [[1, 3], [1, 4], [2, 3], [2, 4]]
         * </pre>
         *
         * @return {object[]} The cartesian product of the given arrays.
         */
        cartesianProduct: function () {
            var arrays = Array.prototype.slice.call(arguments, 0);
            return _.reduce(arrays, function (xs, ys) {
                var result = [];

                _.each(xs, function (x) {
                    _.each(ys, function (y) {
                        result.push(x.concat(y));
                    });
                });

                return result;
            }, [[]]);
        },

        /**
         * Maps a collection, then flattens the resulting array.
         * <p/>
         * See Underscore's <tt>flatten</tt> and <tt>map</tt> functions.
         */
        flatMap: _.compose(_.flatten, _.map),

        /**
         * Sum a list of values.
         *
         * @param {number[]} list The values.
         * @param {object} [context] The context to execute in.
         * @return {number} The sum of all values in <tt>values</tt>.
         */
        sum: function (list, context) {
            return _.reduce(list, function (memo, value) {
                return memo + value;
            }, 0, context);
        }
    });
}());