(function () {
    AJS.namespace("JIRA.WorkflowDesigner.TestMocks");

    /**
     * Link to the global sinon object.
     *
     * @inner
     * @type {Object}
     * @readonly
     */
    var globalSinon = window.sinon;

    /**
     * Mocks for testing.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.TestMocks = {
        /**
         * Generates a mock for window.localStorage
         *
         * @returns {Object} Mocked localStorage
         */
        localStorage: function() {
            return {
                getItem: sinon.stub(),
                setItem: sinon.stub()
            };
        },

        /**
         * @param {Object} [sinon=window.sinon] Sinon main object (or a sinon sandbox) used to create the stubs.
         * @returns {Object} A mock {@link JIRA.WorkflowDesigner.Application}
         */
        application: function(sinon) {
            sinon = sinon || globalSinon;

            return sinon.stub(JIRA.WorkflowDesigner, "Application").returns({
                destroy: sinon.stub()
            });
        },

        /**
         * @param {number[]} bounds The figure's bounds.
         * @return {object} A mock {@link draw2d.Figure} with the given bounds.
         */
        figure: function (bounds) {
            return {
                getBoundingBox: function () {
                    var boundingBox = new draw2d.geo.Rectangle();
                    draw2d.geo.Rectangle.constructor.apply(boundingBox, bounds);
                    return boundingBox;
                }
            };
        },

        /**
         * @return {object} A mock {@link draw2d.Port}
         */
        port: function() {
            return {
                getConnectionDirection: sinon.stub()
            };
        },

        /**
         * @param {number[]} size The view's size.
         * @param {number[]|null[]} [coordinates=[null,null]] The model's coordinates.
         * @return {object} A mock {@link JIRA.WorkflowDesigner.StatusView}.
         */
        statusView: function (size, coordinates) {
            coordinates || (coordinates = [null, null]);

            return {
                getBoundingBox: function () {
                    return new draw2d.geo.Rectangle(0, 0, size[0], size[1]);
                },
                model: new JIRA.WorkflowDesigner.StatusModel({
                    x: coordinates[0],
                    y: coordinates[1]
                }),
                setPosition: sinon.stub()
            };
        },

        /**
         * @param {string} action Value to use in the action property
         * @param {string} object Value to use in the object property
         * @returns {{name: string, properties: {mode: string, action: *, object: *}}} Mocked analytics event
         */
        analyticsEditEvent: function (action, object) {
            return {
                name: "administration.workflow.edit",
                properties: {
                    mode: "new-diagram",
                    action: action,
                    object: object
                }
            };
        }

    };
}());