(function () {
    AJS.namespace("JIRA.WorkflowDesigner.FigureUtilities");

    /**
     * Figure-related utility methods.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.FigureUtilities = {
        /**
         * Calculates the bounding box that contains all given points.
         *
         * @param {draw2d.geo.Point[]} points Array of points.
         * @return {draw2d.geo.Rectangle} the bounding box containing all given points.
         */
        calculateBoundingBox: function (points) {
            var minX = null, maxX = null,
                minY = null, maxY = null,
                width, height;

            _.each(points, function(point) {
                var pointX = point.getX(),
                    pointY = point.getY();

                if (!minX || minX > pointX) {
                    minX = pointX;
                }
                if (!maxX || maxX < pointX) {
                    maxX = pointX;
                }
                if (!minY || minY > pointY) {
                    minY = pointY;
                }
                if (!maxY || maxY < pointY) {
                    maxY = pointY;
                }
            });

            width = maxX - minX;
            height = maxY - minY;

            return new draw2d.geo.Rectangle(minX, minY, width, height);
        }
    };
}());