AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Analytics",{setup:function(){var A=this.sandbox=sinon.sandbox.create(),B=JIRA.WorkflowDesigner.IO.AJAX.UserPropertiesAJAXManager;AJS.EventQueue=[];this.firstAddStepPropertyKey="jira.workflowdesigner.added.first.status";this.firstAddTransitionPropertyKey="jira.workflowdesigner.added.first.transition";this.getPropertyStub=A.stub(B,"getProperty");this.setPropertyStub=A.stub(B,"setProperty")},teardown:function(){delete AJS.EventQueue;JIRA.WorkflowDesigner.Analytics._reset();this.sandbox.restore()}});test("Triggering events",function(){var A=[["triggerAddStatus",["add","status"]],["triggerUpdateStatus",["update","status"]],["triggerAddStep",["add","step"]],["triggerUpdateStep",["update","step"]],["triggerRemoveStep",["remove","step"]],["triggerAddTransition",["add","transition"]],["triggerUpdateTransition",["update","transition"]],["triggerRemoveTransition",["remove","transition"]],["triggerAddGlobalTransition",["add","globaltransition"]],["triggerUpdateGlobalTransition",["update","globaltransition"]],["triggerRemoveGlobalTransition",["remove","globaltransition"]]];_.each(A,function(E){JIRA.WorkflowDesigner.Analytics[E[0]]();var B=JIRA.WorkflowDesigner.TestMocks.analyticsEditEvent.apply(null,E[1]),D=_.last(AJS.EventQueue),C="The method "+E[0]+"() triggers an event with the expected values";deepEqual(D,B,C)},this)});test("Triggering click events",function(){var A=[["enter-full-screen","administration.workflow.fullscreen"],["transition-properties","administration.workflow.view.transition.properties"],["transition-conditions","administration.workflow.view.transition.conditions"],["transition-validators","administration.workflow.view.transition.validators"],["transition-postfunctions","administration.workflow.view.transition.postfunctions"],["status-properties","administration.workflow.view.status.properties"]];_.each(A,function(B){jQuery("<a class='"+B[0]+"'>").appendTo("#qunit-fixture").click();equal(_.last(AJS.EventQueue).name,B[1],"Event with expected name was triggered")})});test("Triggering toggle labels event",function(){JIRA.WorkflowDesigner.Analytics.triggerToggleLabels(true);equal(_.last(AJS.EventQueue).name,"administration.workflow.toggle.labels.on","Toggle labels on event was triggered");JIRA.WorkflowDesigner.Analytics.triggerToggleLabels(false);equal(_.last(AJS.EventQueue).name,"administration.workflow.toggle.labels.off","Toggle labels off event was triggered")});test("Subsequent triggerFirstAddStatus() calls don't make AJAX requests",function(){var A={key:this.firstAddStepPropertyKey,value:true};this.getPropertyStub.returns(jQuery.Deferred().resolve(A));JIRA.WorkflowDesigner.Analytics.triggerFirstAddStatus(42);JIRA.WorkflowDesigner.Analytics.triggerFirstAddStatus(42);equal(this.getPropertyStub.callCount,1,"UserPropertiesAJAXManager#getProperty was only called once")});test("triggerFirstAddStatus()",function(){var A=jQuery.Deferred();this.getPropertyStub.returns(A);JIRA.WorkflowDesigner.Analytics.triggerFirstAddStatus(42);equal(this.getPropertyStub.callCount,1,"UserPropertiesAJAXManager#getProperty was called");deepEqual(this.getPropertyStub.args[0],[this.firstAddStepPropertyKey],"It was passed the correct argument");A.resolve({key:this.firstAddStepPropertyKey,value:null});equal(_.last(AJS.EventQueue).name,"administration.workflow.first.add.status","A first add step event was triggered");deepEqual(_.last(AJS.EventQueue).properties,{duration:42},"It has the correct properties");equal(this.setPropertyStub.callCount,1,"UserPropertiesAJAXManager#setProperty was called");deepEqual(this.setPropertyStub.args[0],[this.firstAddStepPropertyKey,true],"It was passed the correct arguments")});test("triggerFirstAddStatus() fails silently",function(){var A=jQuery.Deferred().reject();this.getPropertyStub.returns(A);JIRA.WorkflowDesigner.Analytics.triggerFirstAddStatus(42);equal(AJS.EventQueue.length,0,"No analytics event was triggered");equal(this.setPropertyStub.callCount,0,"UserPropertiesAJAXManager#setProperty() wasn't called")});test("triggerFirstAddStatus() only triggers an event for the user's first status",function(){var A={key:this.firstAddStepPropertyKey,value:true};this.getPropertyStub.returns(jQuery.Deferred().resolve(A));JIRA.WorkflowDesigner.Analytics.triggerFirstAddStatus(42);equal(AJS.EventQueue.length,0,"No analytics event was triggered");equal(this.setPropertyStub.callCount,0,"UserPropertiesAJAXManager#setProperty wasn't called")});test("Subsequent triggerFirstAddTransition() calls don't make AJAX requests",function(){var A={key:this.firstAddTransitionPropertyKey,value:true};this.getPropertyStub.returns(jQuery.Deferred().resolve(A));JIRA.WorkflowDesigner.Analytics.triggerFirstAddTransition(42);JIRA.WorkflowDesigner.Analytics.triggerFirstAddTransition(42);equal(this.getPropertyStub.callCount,1,"UserPropertiesAJAXManager#getProperty was only called once")});test("triggerFirstAddTransition()",function(){var A=jQuery.Deferred();this.getPropertyStub.returns(A);JIRA.WorkflowDesigner.Analytics.triggerFirstAddTransition(42);equal(this.getPropertyStub.callCount,1,"UserPropertiesAJAXManager#getProperty was called");deepEqual(this.getPropertyStub.args[0],[this.firstAddTransitionPropertyKey],"It was passed the correct argument");A.resolve({key:this.firstAddTransitionPropertyKey,value:null});equal(_.last(AJS.EventQueue).name,"administration.workflow.first.add.transition","A first add transition event was triggered");deepEqual(_.last(AJS.EventQueue).properties,{duration:42},"It has the correct properties");equal(this.setPropertyStub.callCount,1,"UserPropertiesAJAXManager#setProperty was called");deepEqual(this.setPropertyStub.args[0],[this.firstAddTransitionPropertyKey,true],"It was passed the correct arguments")});test("triggerFirstAddStatus() fails silently",function(){var A=jQuery.Deferred().reject();this.getPropertyStub.returns(A);JIRA.WorkflowDesigner.Analytics.triggerFirstAddTransition(42);equal(AJS.EventQueue.length,0,"No analytics event was triggered");equal(this.setPropertyStub.callCount,0,"UserPropertiesAJAXManager#setProperty() wasn't called")});test("triggerFirstAddStatus() only triggers an event for the user's first status",function(){var A={key:this.firstAddTransitionPropertyKey,value:true};this.getPropertyStub.returns(jQuery.Deferred().resolve(A));JIRA.WorkflowDesigner.Analytics.triggerFirstAddTransition(42);equal(AJS.EventQueue.length,0,"No analytics event was triggered");equal(this.setPropertyStub.callCount,0,"UserPropertiesAJAXManager#setProperty wasn't called")});