(function (Backbone) {
    /**
     * @class JIRA.WorkflowDesigner.StatusModel
     * @classdesc A status in a JIRA workflow.
     * @extends Backbone.Model
     */
    Backbone.define("JIRA.WorkflowDesigner.StatusModel", Backbone.Model.extend(
    /** @lends JIRA.WorkflowDesigner.StatusModel# */
    {
        defaults: {
            description: "",
            id: null,
            initial: false,
            name: "",
            statusCategory: null,
            statusId: null,
            stepId: null,
            x: null,
            y: null
        },

        /**
         * @return {boolean} Whether the status has x and y coordinates.
         */
        hasCoordinates: function () {
            var x = this.get("x"),
                y = this.get("y");

            return _.isNumber(x) && _.isNumber(y);
        },

        /**
         * Checks if this status is connected to the provided transition.
         *
         * @param {JIRA.WorkflowDesigner.TransitionModel} transition Transition to check.
         * @return {boolean} Whether the status is connected to the transition.
         */
        hasTransition: function (transition) {
            return (transition.get("source") === this || transition.get("target") === this);
        },

        /**
         * @return {boolean} Whether this is the workflow's initial status.
         */
        isInitial: function () {
            return this.get("initial");
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));