AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.IO.WorkflowDataWriter", {
    setup: function () {
        this.workflowModel = new JIRA.WorkflowDesigner.WorkflowModel({
            name: "Workflow",
            liveStepIds: [1]
        });
        this.write = JIRA.WorkflowDesigner.IO.WorkflowDataWriter.write;
    }
});

test("write()", function () {
    var expectedResult,
        instance = this;

    function findStatus(id) {
        var statuses = instance.workflowModel.get("statuses").models;
        return _.where(statuses, {id: id})[0];
    }

    _.each(simpleLayoutModelAttributes.statuses, function (attributes) {
        instance.workflowModel.addStatus(attributes);
    });

    _.each(simpleLayoutModelAttributes.transitions, function (attributes) {
        attributes = _.chain(attributes).omit("sourceId", "targetId").extend({
            source: findStatus(attributes.sourceId),
            target: findStatus(attributes.targetId)
        }).value();

        instance.workflowModel.addTransition(attributes);
    });

    expectedResult = {
        draft: false,
        name: "Workflow",
        layout: _.omit(simpleLayoutJSON, "updateAuthor", "updatedDate")
    };

    deepEqual(this.write(this.workflowModel), expectedResult, "write() returned the correct JSON");
});

test("write() returns the correct source IDs for global transitions", function () {
    this.workflowModel.addTransition({
        globalTransition: true,
        target: this.workflowModel.addStatus({id: "status"})
    });

    equal(this.write(this.workflowModel).layout.transitions[0].sourceId, "status",
            "The transition's source ID is correct");
});