(function () {
    AJS.namespace("JIRA.WorkflowDesigner.IO.WorkflowDataReader");

    /**
     * Loads workflow data.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.IO.WorkflowDataReader = {
        /**
         * Read workflow information from JSON.
         *
         * @param {Object} data The JSON workflow data.
         * @return {object|undefined} The result of parsing <tt>data</tt> or <tt>undefined</tt> on failure.
         */
        read: function (data) {
            var statusModels = {},
                transitionModels = [];

            if (!data || !data.statuses || !data.transitions) {
                return;
            }

            _.each(data.statuses, function (status) {
                var statusModel = new JIRA.WorkflowDesigner.StatusModel(status);
                statusModels[statusModel.id] = statusModel;
            });

            _.each(data.transitions, function (transition) {
                transitionModels.push(createTransitionModel(transition, statusModels));
            });

            return {
                statuses: _.values(statusModels),
                transitions: transitionModels,
                updateAuthor: data.updateAuthor,
                updatedDate: new Date(data.updatedDate)
            };
        }
    };

    /**
     * @inner
     *
     * @param {Object} attributes
     * @param {Object} statusModels
     * @returns {JIRA.WorkflowDesigner.TransitionModel}
     */
    function createTransitionModel(attributes, statusModels) {
        attributes = _.chain(attributes).omit("sourceId", "targetId").extend({
            source: statusModels[attributes.sourceId],
            target: statusModels[attributes.targetId]
        }).value();

        return new JIRA.WorkflowDesigner.TransitionModel(attributes);
    }
}());