/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.util;

import java.util.HashMap;
import java.util.Map;

public class TokenMap<K, V>
extends HashMap<K, V> {
    private long tokenTimeout;
    private final Map<K, Long> tokenTimeouts;

    public TokenMap(long tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
        this.tokenTimeouts = new HashMap<K, Long>();
    }

    @Override
    public V put(K key, V value) {
        this.tokenTimeouts.put(key, this.nextExpiryTime());
        return super.put(key, value);
    }

    @Override
    public V get(Object key) {
        if (!super.containsKey(key)) {
            return null;
        }
        Long expiryTime = this.tokenTimeouts.get(key);
        if (expiryTime == null) {
            this.tokenTimeouts.remove(key);
            super.remove(key);
            return null;
        }
        if (expiryTime < System.currentTimeMillis()) {
            this.tokenTimeouts.remove(key);
            super.remove(key);
            return null;
        }
        this.tokenTimeouts.put(key, this.nextExpiryTime());
        return super.get(key);
    }

    private Long nextExpiryTime() {
        return System.currentTimeMillis() + this.tokenTimeout;
    }

    @Override
    public V remove(Object key) {
        this.tokenTimeouts.remove(key);
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.tokenTimeouts.clear();
        super.clear();
    }
}

