/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.util;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class StatusUtils {
    public static final String STATUS_ENTITY_NAME = "Status";
    private static final String NEW_STATUS_DEFAULT_ICON = "/images/icons/statuses/generic.png";
    private static final Long NEW_STATUS_START_ID = new Long(10000L);
    private Map fields;

    public GenericValue addStatus(String name, String description, String iconurl) throws GenericEntityException {
        if (new Long(EntityUtils.getNextStringId((String)STATUS_ENTITY_NAME)) < NEW_STATUS_START_ID) {
            this.addField("id", NEW_STATUS_START_ID.toString());
        } else {
            this.addField("id", EntityUtils.getNextStringId((String)STATUS_ENTITY_NAME));
        }
        this.addField("name", name);
        this.addField("description", description);
        this.addField("iconurl", iconurl);
        this.addField("sequence", new Long(this.getMaxSequenceNo() + 1L));
        GenericValue createdValue = EntityUtils.createValue((String)STATUS_ENTITY_NAME, (Map)this.getFields());
        name = null;
        description = null;
        ConstantsManager cman = ManagerFactory.getConstantsManager();
        cman.refreshStatuses();
        return createdValue;
    }

    public GenericValue updateStatus(String id, String name, String description, String iconurl) throws GenericEntityException {
        GenericValue gv = this.getStatus(id);
        gv.set("name", (Object)name);
        gv.set("description", (Object)description);
        gv.set("iconurl", (Object)iconurl);
        gv.store();
        ConstantsManager cman = ManagerFactory.getConstantsManager();
        cman.refreshStatuses();
        return gv;
    }

    public GenericValue deleteStatus(String id) throws GenericEntityException {
        GenericValue gv = this.getStatus(id);
        gv.remove();
        ConstantsManager cman = ManagerFactory.getConstantsManager();
        cman.refreshStatuses();
        return gv;
    }

    public static boolean isActive(GenericValue statusGV) {
        boolean active = false;
        WorkflowManager workflowManager = ComponentManager.getInstance().getWorkflowManager();
        Collection workflows = workflowManager.getWorkflows();
        for (JiraWorkflow workflow : workflows) {
            List linkStatuses = workflow.getLinkedStatuses();
            if (!linkStatuses.contains(statusGV)) continue;
            active = true;
            break;
        }
        return active;
    }

    protected GenericValue getStatus(String id) {
        ConstantsManager cman = ManagerFactory.getConstantsManager();
        return cman.getStatus(id);
    }

    protected void addField(String key, Object value) {
        if (this.getFields() == null) {
            this.fields = new HashMap();
        }
        this.getFields().put(key, value);
    }

    private Map getFields() {
        return this.fields;
    }

    private long getMaxSequenceNo() {
        ConstantsManager cman = ManagerFactory.getConstantsManager();
        Collection constants = cman.getConstantObjects(STATUS_ENTITY_NAME);
        long maxSequence = 0L;
        for (Status status : constants) {
            long thisSequence = status.getGenericValue().getLong("sequence");
            if (thisSequence <= maxSequence) continue;
            maxSequence = thisSequence;
        }
        return maxSequence;
    }
}

