/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.servlet;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowImageManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowImageParams;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowThumbnailParams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WorkflowThumbnailServlet
extends HttpServlet {
    public static Logger log = Logger.getLogger(WorkflowThumbnailServlet.class);
    public static final String CONTENTTYPE_PNG = "image/png";
    public static final String PARAM_WORKFLOW_NAME = "workflowName";
    public static final String PARAM_WORKFLOW_MODE = "mode";
    public static final String PARAM_WIDTH = "width";
    public static final String PARAM_HEIGHT = "height";
    public static final String PARAM_MAINTAIN_ASPECT = "maintainAspect";
    public static final String PARAM_STEP_ID = "stepId";
    public static final String PARAM_SHOW_LABELS = "showLabels";
    public static final String DEFAULT_WORKFLOW_MODE = "live";
    public static final String DEFAULT_WIDTH = "600";
    public static final String DEFAULT_HEIGHT = "800";
    public static final String DEFAULT_MAINTAIN_ASPECT = "false";
    public static final String DEFAULT_SHOW_LABELS = "true";
    public static final String DEFAULT_STEP_ID = "-1";
    public static final String FULL = "full";
    private final WorkflowService workflowService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowImageManager workflowImageManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final ProjectService projectService;
    private final PermissionManager permissionManager;

    public WorkflowThumbnailServlet(WorkflowService workflowService, JiraAuthenticationContext jiraAuthenticationContext, WorkflowImageManager workflowImageManager, PermissionManager permissionManager, WorkflowSchemeManager workflowSchemeManager, ProjectService projectService) {
        this.workflowService = workflowService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workflowImageManager = workflowImageManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.projectService = projectService;
        this.permissionManager = permissionManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getWorkflowImage(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWorkflowImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        InputStream imageStream;
        block20: {
            int returnStatus = 200;
            String workflowNameParam = request.getParameter(PARAM_WORKFLOW_NAME);
            String workflowModeParam = StringUtils.defaultString((String)request.getParameter(PARAM_WORKFLOW_MODE), (String)DEFAULT_WORKFLOW_MODE);
            String widthParam = StringUtils.defaultString((String)request.getParameter(PARAM_WIDTH), (String)DEFAULT_WIDTH);
            String heightParam = StringUtils.defaultString((String)request.getParameter(PARAM_HEIGHT), (String)DEFAULT_HEIGHT);
            String maintainAspectParam = StringUtils.defaultString((String)request.getParameter(PARAM_MAINTAIN_ASPECT), (String)DEFAULT_MAINTAIN_ASPECT);
            String stepIdParam = StringUtils.defaultString((String)request.getParameter(PARAM_STEP_ID), (String)DEFAULT_STEP_ID);
            String showLabelsParam = StringUtils.defaultString((String)request.getParameter(PARAM_SHOW_LABELS), (String)DEFAULT_SHOW_LABELS);
            if (!workflowModeParam.equals(DEFAULT_WORKFLOW_MODE) && !workflowModeParam.equals("draft")) {
                workflowModeParam = DEFAULT_WORKFLOW_MODE;
            }
            if (!StringUtils.isNumeric((String)widthParam) && !FULL.equals(widthParam)) {
                widthParam = DEFAULT_WIDTH;
            }
            if (!StringUtils.isNumeric((String)heightParam) && !FULL.equals(heightParam)) {
                heightParam = DEFAULT_HEIGHT;
            }
            if (!StringUtils.isNumeric((String)stepIdParam)) {
                stepIdParam = DEFAULT_STEP_ID;
            }
            int stepId = Integer.parseInt(stepIdParam);
            boolean showLabels = Boolean.parseBoolean(showLabelsParam);
            boolean maintainAspect = Boolean.parseBoolean(maintainAspectParam);
            ApplicationUser user = this.jiraAuthenticationContext.getUser();
            imageStream = null;
            try {
                if (StringUtils.isNotBlank((String)workflowNameParam)) {
                    JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(user);
                    JiraWorkflow workflow = workflowModeParam.equals("draft") ? this.workflowService.getDraftWorkflow((JiraServiceContext)jiraServiceContext, workflowNameParam) : this.workflowService.getWorkflow((JiraServiceContext)jiraServiceContext, workflowNameParam);
                    if (workflow != null && this.hasPermissionToViewWorkflow(workflowNameParam, user)) {
                        try {
                            if (!FULL.equals(widthParam) && !FULL.equals(heightParam)) {
                                int width = Integer.parseInt(widthParam);
                                int height = Integer.parseInt(heightParam);
                                if (width < 20) {
                                    width = 20;
                                }
                                if (width > 3000) {
                                    width = 3000;
                                }
                                if (height < 20) {
                                    height = 20;
                                }
                                if (height > 3000) {
                                    height = 3000;
                                }
                                WorkflowThumbnailParams params = new WorkflowThumbnailParams.Builder(workflow).setStepId(stepId).setWidth(width).setHeight(height).setShowLabels(showLabels).setMaintainAspect(maintainAspect).build();
                                imageStream = this.workflowImageManager.getThumbnailStream(params);
                            } else {
                                WorkflowImageParams params = new WorkflowImageParams.Builder(workflow).setStepId(stepId).setShowLabels(showLabels).build();
                                imageStream = this.workflowImageManager.getFullImageStream(params);
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Error getting workflow thumbnail, returning default image.", (Throwable)e);
                        }
                    }
                }
                if (imageStream == null || imageStream.available() < 1) {
                    returnStatus = 404;
                }
                response.setContentType(CONTENTTYPE_PNG);
                response.setStatus(returnStatus);
                if (200 != returnStatus) break block20;
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
                ServletOutputStream out = response.getOutputStream();
                try {
                    IOUtils.copy((InputStream)imageStream, (OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(imageStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)imageStream);
    }

    private boolean hasPermissionToViewWorkflow(String workflowNameParam, ApplicationUser user) {
        List<Project> projectsForWorkflow = this.getProjectsForWorkflow(workflowNameParam, user);
        boolean hasPermissionToViewWorkflow = this.permissionManager.hasPermission(0, user);
        if (!hasPermissionToViewWorkflow) {
            for (Project project : projectsForWorkflow) {
                if (!this.permissionManager.hasPermission(45, project, user) && !ProjectAction.VIEW_PROJECT.hasPermission(this.permissionManager, user, project)) continue;
                hasPermissionToViewWorkflow = true;
                break;
            }
        }
        return hasPermissionToViewWorkflow;
    }

    private List<Project> getProjectsForWorkflow(String workflowName, ApplicationUser user) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Project project : this.getAllProjects(user)) {
            Map workflowMap = this.workflowSchemeManager.getWorkflowMap(project);
            String defaultWorkflow = (String)workflowMap.get(null);
            if (defaultWorkflow == null) {
                defaultWorkflow = "jira";
            }
            for (IssueType type : project.getIssueTypes()) {
                String workflow = (String)workflowMap.get(type.getId());
                if (workflow == null) {
                    workflow = defaultWorkflow;
                }
                if (!workflowName.equals(workflow)) continue;
                result.put((Object)workflow, (Object)project);
            }
        }
        return Lists.newArrayList((Iterable)result.get((Object)workflowName));
    }

    private List<Project> getAllProjects(ApplicationUser user) {
        ServiceOutcome projectsForAction = this.projectService.getAllProjectsForAction(user, ProjectAction.VIEW_PROJECT);
        if (projectsForAction.isValid()) {
            return (List)projectsForAction.getReturnedValue();
        }
        return Collections.emptyList();
    }
}

