/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.model.layout.serialize;

import com.sysbliss.jira.plugins.workflow.model.layout.AnnotationLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.JWDSerializableLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.JWDSerializableLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.LayoutSerializer;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableAnnotation;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableAnnotationImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableEdge;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableEdgeImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableNode;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableNodeImpl;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class JSONLayoutSerializer
implements LayoutSerializer {
    private JWDSerializableLayout _layout;
    private Map<String, SerializableEdge> _edgeMap;
    private Map<String, SerializableNode> _nodeMap;
    private List<SerializableAnnotation> _annotations;

    @Override
    public String serialize(JWDLayout layout) throws Exception {
        this._layout = new JWDSerializableLayoutImpl();
        this._edgeMap = new HashMap<String, SerializableEdge>();
        this._nodeMap = new HashMap<String, SerializableNode>();
        this._annotations = new ArrayList<SerializableAnnotation>();
        ArrayList<String> rootIds = new ArrayList<String>(layout.getRoots().size());
        this._layout.setWidth(layout.getWidth());
        List<NodeLayout> roots = layout.getRoots();
        int n = roots.size();
        for (int i = 0; i < n; ++i) {
            NodeLayout nodeLayout = roots.get(i);
            this.serializeNode(nodeLayout);
            rootIds.add(nodeLayout.getId());
        }
        for (AnnotationLayout annotationLayout : layout.getAnnotations()) {
            this.serializeAnnotation(annotationLayout);
        }
        this._layout.setRootIds(rootIds);
        this._layout.setEdgeMap(this._edgeMap);
        this._layout.setNodeMap(this._nodeMap);
        this._layout.setAnnotations(this._annotations);
        ObjectMapper mapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        mapper.writeValue((Writer)sw, (Object)this._layout);
        this._layout = null;
        this._edgeMap = null;
        this._nodeMap = null;
        this._annotations = null;
        return sw.toString();
    }

    private void serializeAnnotation(AnnotationLayout annotationLayout) {
        SerializableAnnotationImpl annotation = new SerializableAnnotationImpl();
        annotation.setId(annotationLayout.getId());
        annotation.setRect(annotationLayout.getRect());
        this._annotations.add(annotation);
    }

    private void serializeNode(NodeLayout nodeLayout) {
        if (this._nodeMap.containsKey(nodeLayout.getId())) {
            return;
        }
        SerializableNodeImpl node = new SerializableNodeImpl();
        node.setId(nodeLayout.getId());
        node.setLabel(nodeLayout.getLabel());
        this._nodeMap.put(nodeLayout.getId(), node);
        node.setStepId(nodeLayout.getStepId());
        node.setIsInitialAction(nodeLayout.getIsInitialAction());
        node.setRect(nodeLayout.getRect());
        ArrayList<String> inLinkIds = new ArrayList<String>(nodeLayout.getInLinks().size());
        ArrayList<String> outLinkIds = new ArrayList<String>(nodeLayout.getOutLinks().size());
        for (EdgeLayout edgeLayout : nodeLayout.getInLinks()) {
            this.serializeEdge(edgeLayout);
            inLinkIds.add(edgeLayout.getId());
        }
        node.setInLinkIds(inLinkIds);
        for (EdgeLayout edgeLayout : nodeLayout.getOutLinks()) {
            this.serializeEdge(edgeLayout);
            outLinkIds.add(edgeLayout.getId());
        }
        node.setOutLinkIds(outLinkIds);
    }

    private void serializeEdge(EdgeLayout edgeLayout) {
        if (this._edgeMap.containsKey(edgeLayout.getId())) {
            return;
        }
        SerializableEdgeImpl edge = new SerializableEdgeImpl();
        edge.setId(edgeLayout.getId());
        edge.setLabel(edgeLayout.getLabel());
        this._edgeMap.put(edgeLayout.getId(), edge);
        edge.setActionId(edgeLayout.getActionId());
        edge.setStartStepId(edgeLayout.getStartStepId());
        edge.setEndStepId(edgeLayout.getEndStepId());
        edge.setStartPoint(edgeLayout.getStartPoint());
        edge.setEndPoint(edgeLayout.getEndPoint());
        edge.setControlPoints(edgeLayout.getControlPoints());
        edge.setLineType(edgeLayout.getLineType());
        edge.setLabelPoint(edgeLayout.getLabelPoint());
        this.serializeNode(edgeLayout.getStartNode());
        edge.setStartNodeId(edgeLayout.getStartNode().getId());
        this.serializeNode(edgeLayout.getEndNode());
        edge.setEndNodeId(edgeLayout.getEndNode().getId());
    }
}

