/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.manager;

import com.atlassian.jira.workflow.JiraWorkflow;

public class WorkflowImageParams {
    private JiraWorkflow workflow;
    private int stepId;
    private boolean showLabels;

    private WorkflowImageParams(JiraWorkflow workflow, int stepId, boolean showLabels) {
        this.workflow = workflow;
        this.stepId = stepId;
        this.showLabels = showLabels;
    }

    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public int getStepId() {
        return this.stepId;
    }

    public boolean showLabels() {
        return this.showLabels;
    }

    public static class Builder {
        private JiraWorkflow workflow;
        private int stepId;
        private boolean showLabels;

        public Builder(JiraWorkflow workflow) {
            this.workflow = workflow;
            this.stepId = -1;
            this.showLabels = false;
        }

        public Builder setStepId(int stepId) {
            this.stepId = stepId;
            return this;
        }

        public Builder setShowLabels(boolean showLabels) {
            this.showLabels = showLabels;
            return this;
        }

        public WorkflowImageParams build() {
            return new WorkflowImageParams(this.workflow, this.stepId, this.showLabels);
        }
    }
}

