/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.jgraph;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.google.common.collect.Lists;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.sysbliss.jira.plugins.workflow.jgraph.JGraphxWorkflowStyles;
import com.sysbliss.jira.plugins.workflow.jgraph.JWDParallelEdgeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutObject;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutPoint;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutPointImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutRect;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayout;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTextFieldUI;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class JGraphxJWDLayoutProcessor {
    public static final Logger log = Logger.getLogger(JGraphxJWDLayoutProcessor.class);
    public static final String ICON_PREFIX = "/images/icons/statuses/";
    public static final String ROOTS = "roots";
    public static final String GRAPH = "graph";
    private static final String LINE_TYPE_POLYLINE = "poly";
    private static final String LINE_TYPE_LINE = "straight";
    private final Map<String, mxCell> jgraphVertexCache = new HashMap<String, mxCell>();
    private final Map<String, mxCell> jgraphEdgeCache = new HashMap<String, mxCell>();
    private final Map<String, NodeLayout> nodeLayoutCache = new HashMap<String, NodeLayout>();
    private final Map<String, EdgeLayout> edgeLayoutCache = new HashMap<String, EdgeLayout>();
    private final List<mxCell> rootCells = new ArrayList<mxCell>();
    private final ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
    private final boolean showLabels;

    private JGraphxJWDLayoutProcessor(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public static Map<String, Object> calculateLayout(List<NodeLayout> roots, JiraWorkflow workflow) {
        return new JGraphxJWDLayoutProcessor(true).actuallyCalculateLayout(roots, workflow);
    }

    private synchronized Map<String, Object> actuallyCalculateLayout(List<NodeLayout> roots, JiraWorkflow workflow) {
        HashMap<String, Object> returnVals = new HashMap<String, Object>();
        mxCell layer = new mxCell("", new mxGeometry(0.0, 0.0, 0.0, 0.0), "JIRALAYER");
        layer.setVertex(true);
        layer.setConnectable(false);
        mxGraph graph = this.mxGraphFromJWDLayout(layer, roots, workflow, -1);
        mxCell defaultParent = (mxCell)graph.getDefaultParent();
        mxCell parent = (mxCell)defaultParent.getChildAt(0);
        JWDParallelEdgeLayout edgeLayout = new JWDParallelEdgeLayout(graph, 30);
        mxHierarchicalLayout layout = new mxHierarchicalLayout(graph);
        layout.setFineTuning(true);
        layout.setInterRankCellSpacing(40.0);
        layout.setIntraCellSpacing(70.0);
        layout.setResizeParent(true);
        layout.execute(parent, Lists.newArrayList(this.rootCells));
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            mxCell cell = (mxCell)parent.getChildAt(i);
            if (!cell.isEdge()) continue;
            cell.getGeometry().setPoints(null);
        }
        edgeLayout.execute(defaultParent);
        mxRectangle graphBounds = graph.getMaximumGraphBounds();
        mxRectangle layerBounds = graph.getBoundingBox(parent, true);
        parent.getGeometry().setX(graphBounds.getCenterX() - layerBounds.getCenterX());
        List<NodeLayout> newRoots = this.createReturnLayout(graph, parent);
        LayoutRect oldRect = null;
        for (NodeLayout root : newRoots) {
            if (oldRect != null) {
                root.getRect().setX(oldRect.getX() + oldRect.getWidth() + 20.0);
            }
            oldRect = root.getRect();
        }
        returnVals.put(ROOTS, newRoots);
        returnVals.put(GRAPH, graph);
        return returnVals;
    }

    public static mxGraph mxGraphFromJWDLayout(List<NodeLayout> roots, JiraWorkflow workflow, int stepId, boolean showLabels) {
        return new JGraphxJWDLayoutProcessor(showLabels).mxGraphFromJWDLayout(null, roots, workflow, stepId);
    }

    private mxGraph mxGraphFromJWDLayout(Object parent, List<NodeLayout> roots, JiraWorkflow workflow, int stepId) {
        mxGraph graph = new mxGraph(){

            @Override
            public String convertValueToString(Object cell) {
                Object value;
                if (cell instanceof mxCell && (value = ((mxCell)cell).getValue()) instanceof LayoutObject) {
                    String label = ((LayoutObject)value).getLabel();
                    return StringUtils.normalizeSpace((String)label);
                }
                return super.convertValueToString(cell);
            }
        };
        graph.setKeepEdgesInBackground(true);
        mxRectangle bounds = new mxRectangle(0.0, 0.0, 3072.0, 2304.0);
        graph.setMinimumGraphSize(bounds);
        graph.setMaximumGraphBounds(bounds);
        graph.setAllowLoops(true);
        graph.setCellsBendable(true);
        mxStylesheet stylesheet = graph.getStylesheet();
        stylesheet.putCellStyle("JIRALAYER", JGraphxWorkflowStyles.STYLE_LAYER);
        stylesheet.putCellStyle("JIRASTEP", JGraphxWorkflowStyles.STYLE_JIRA_STEP);
        stylesheet.putCellStyle("SELECTEDJIRASTEP", JGraphxWorkflowStyles.STYLE_JIRA_STEP_SELECTED);
        stylesheet.putCellStyle("JIRAACTION", JGraphxWorkflowStyles.STYLE_JIRA_ACTION);
        graph.setDefaultLoopStyle(JGraphxWorkflowStyles.JIRA_EDGE_LOOP);
        if (parent == null) {
            parent = graph.getDefaultParent();
        } else {
            graph.addCell(parent);
        }
        this.createGraphTree(graph, parent, roots, workflow, stepId);
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGraphTree(mxGraph graph, Object parent, List<NodeLayout> roots, JiraWorkflow workflow, int stepId) {
        graph.getModel().beginUpdate();
        try {
            for (NodeLayout rootLayout : roots) {
                this.rootCells.add(this.createNode(graph, parent, rootLayout, workflow, stepId));
            }
        }
        finally {
            graph.getModel().endUpdate();
        }
    }

    private mxCell createNode(mxGraph graph, Object parent, NodeLayout nodeLayout, JiraWorkflow workflow, int stepId) {
        mxCell node;
        if (!this.jgraphVertexCache.containsKey(nodeLayout.getId())) {
            String iconUrl = this.getIconUrlForStep(nodeLayout.getStepId(), workflow);
            String nodeStyle = "JIRASTEP;" + mxConstants.STYLE_IMAGE + "=" + iconUrl;
            if (stepId > -1 && nodeLayout.getStepId().equals(stepId) && !nodeLayout.getIsInitialAction().booleanValue()) {
                nodeStyle = "SELECTEDJIRASTEP;" + mxConstants.STYLE_IMAGE + "=" + iconUrl;
            }
            if ((node = (mxCell)graph.insertVertex(parent, null, nodeLayout, nodeLayout.getRect().getX(), nodeLayout.getRect().getY(), nodeLayout.getRect().getWidth(), nodeLayout.getRect().getHeight(), nodeStyle)).getGeometry().getWidth() < 1.0 || node.getGeometry().getHeight() < 1.0) {
                graph.updateCellSize(node);
            }
            this.jgraphVertexCache.put(nodeLayout.getId(), node);
        } else {
            node = this.jgraphVertexCache.get(nodeLayout.getId());
        }
        for (EdgeLayout edgeLayout : nodeLayout.getOutLinks()) {
            if (this.jgraphEdgeCache.containsKey(edgeLayout.getId())) continue;
            this.createEdge(graph, parent, node, edgeLayout, workflow, stepId);
        }
        return node;
    }

    private String getIconUrlForStep(Integer stepId, JiraWorkflow workflow) {
        String statusId;
        Status status;
        Map metaAttributes;
        URL genericUrl = this.getClass().getClassLoader().getResource("status-icons/generic-32.png");
        String iconUrl = null;
        if (genericUrl != null) {
            iconUrl = genericUrl.toString();
        }
        String origUrl = "";
        StepDescriptor step = workflow.getDescriptor().getStep(stepId.intValue());
        if (step != null && (metaAttributes = step.getMetaAttributes()) != null && (status = this.constantsManager.getStatusObject(statusId = (String)metaAttributes.get("jira.status.id"))) != null) {
            origUrl = status.getIconUrl();
        }
        if (origUrl.startsWith(ICON_PREFIX)) {
            String statusName = StringUtils.substringBetween((String)origUrl, (String)ICON_PREFIX, (String)".png");
            String newName = "status-icons/" + statusName + "-32.png";
            URL url = this.getClass().getClassLoader().getResource(newName);
            if (url != null) {
                iconUrl = url.toString();
            }
        }
        return iconUrl;
    }

    private void createEdge(mxGraph graph, Object parent, mxCell startNode, EdgeLayout edgeLayout, JiraWorkflow workflow, int stepId) {
        if (!this.jgraphEdgeCache.containsKey(edgeLayout.getId())) {
            if (!this.showLabels) {
                edgeLayout.setLabel("");
                edgeLayout.setLabelPoint(null);
            }
            mxCell edge = new mxCell(edgeLayout, new mxGeometry(), "");
            edge.setEdge(true);
            edge.getGeometry().setRelative(false);
            this.jgraphEdgeCache.put(edgeLayout.getId(), edge);
            mxCell endNode = this.createNode(graph, parent, edgeLayout.getEndNode(), workflow, stepId);
            mxPoint lineStart = new mxPoint(edgeLayout.getStartPoint().getX(), edgeLayout.getStartPoint().getY());
            mxPoint lineEnd = new mxPoint(edgeLayout.getEndPoint().getX(), edgeLayout.getEndPoint().getY());
            mxPoint startTerminate = new mxPoint(edgeLayout.getEndPoint().getX(), edgeLayout.getEndPoint().getY());
            mxPoint endBegin = new mxPoint(edgeLayout.getStartPoint().getX(), edgeLayout.getStartPoint().getY());
            if (edgeLayout.getControlPoints().size() > 0) {
                startTerminate = new mxPoint(edgeLayout.getControlPoints().get(0).getX(), edgeLayout.getControlPoints().get(0).getY());
                endBegin = new mxPoint(edgeLayout.getControlPoints().get(edgeLayout.getControlPoints().size() - 1).getX(), edgeLayout.getControlPoints().get(edgeLayout.getControlPoints().size() - 1).getY());
            }
            mxPoint startIntersect = this.getIntersection(lineStart, startTerminate, startNode);
            mxPoint endIntersect = this.getIntersection(endBegin, lineEnd, endNode);
            double startPercentX = (startIntersect.getX() - startNode.getGeometry().getX()) / startNode.getGeometry().getWidth();
            double startPercentY = (startIntersect.getY() - startNode.getGeometry().getY()) / startNode.getGeometry().getHeight();
            double endPercentX = (endIntersect.getX() - endNode.getGeometry().getX()) / endNode.getGeometry().getWidth();
            double endPercentY = (endIntersect.getY() - endNode.getGeometry().getY()) / endNode.getGeometry().getHeight();
            mxPoint exitPoint = new mxPoint(startPercentX, startPercentY);
            mxPoint entryPoint = new mxPoint(endPercentX, endPercentY);
            StringBuilder edgeStyle = new StringBuilder("JIRAACTION");
            if (!Double.isNaN(entryPoint.getX()) && !Double.isNaN(entryPoint.getY())) {
                edgeStyle.append(";entryX=");
                edgeStyle.append(entryPoint.getX());
                edgeStyle.append(";entryY=");
                edgeStyle.append(entryPoint.getY());
                edgeStyle.append(";entryPerimeter=0");
            }
            if (!Double.isNaN(exitPoint.getX()) && !Double.isNaN(exitPoint.getY())) {
                edgeStyle.append(";exitX=");
                edgeStyle.append(exitPoint.getX());
                edgeStyle.append(";exitY=");
                edgeStyle.append(exitPoint.getY());
                edgeStyle.append(";exitPerimeter=0");
            }
            edge = (mxCell)graph.addEdge(edge, parent, startNode, endNode, null);
            edgeStyle.append(";");
            edge.setStyle(edgeStyle.toString());
            if (!LINE_TYPE_LINE.equals(edgeLayout.getLineType()) && edgeLayout.getControlPoints().size() > 0) {
                if (edge.getGeometry().getPoints() == null) {
                    edge.getGeometry().setPoints(new ArrayList<mxPoint>());
                }
                for (LayoutPoint cpoint : edgeLayout.getControlPoints()) {
                    edge.getGeometry().getPoints().add(new mxPoint(cpoint.getX(), cpoint.getY()));
                }
            }
            if (edgeLayout.getLabelPoint() != null && edgeLayout.getLabelPoint().getX() > 0.0 && edgeLayout.getLabelPoint().getY() > 0.0) {
                graph.getView().revalidate();
                mxCellState edgeState = graph.getView().getState(edge);
                double offsetX = edgeLayout.getLabelPoint().getX() - edgeState.getLabelBounds().getX();
                double offsetY = edgeLayout.getLabelPoint().getY() - edgeState.getLabelBounds().getY();
                edge.getGeometry().setOffset(new mxPoint(offsetX, offsetY));
            }
        }
    }

    private List<NodeLayout> createReturnLayout(mxGraph graph, Object parent) {
        ArrayList<NodeLayout> returnList = new ArrayList<NodeLayout>();
        for (mxCell topLevelNode : this.rootCells) {
            NodeLayout rootNode = this.createReturnNode(graph, parent, topLevelNode);
            returnList.add(rootNode);
        }
        return returnList;
    }

    private NodeLayout createReturnNode(mxGraph graph, Object parent, mxCell node) {
        NodeLayout nodeLayout = (NodeLayout)node.getValue();
        if (!this.nodeLayoutCache.containsKey(nodeLayout.getId())) {
            LayoutRect nodeRect = nodeLayout.getRect();
            mxGeometry geom = node.getGeometry();
            double offsetX = ((mxCell)parent).getGeometry().getX();
            nodeRect.setX(geom.getX() + offsetX);
            nodeRect.setY(geom.getY());
            nodeRect.setWidth(geom.getWidth());
            nodeRect.setHeight(geom.getHeight());
            nodeLayout.setRect(nodeRect);
            this.nodeLayoutCache.put(nodeLayout.getId(), nodeLayout);
        }
        this.createReturnEdges(graph, parent, node);
        return nodeLayout;
    }

    private void createReturnEdges(mxGraph graph, Object parent, mxCell startNode) {
        int edgeCount = startNode.getEdgeCount();
        double offsetX = ((mxCell)parent).getGeometry().getX();
        for (int e = 0; e < edgeCount; ++e) {
            mxCell edgeCell = (mxCell)startNode.getEdgeAt(e);
            EdgeLayout edgeLayout = (EdgeLayout)edgeCell.getValue();
            LayoutPointImpl labelPoint = new LayoutPointImpl();
            mxCellState edgeState = graph.getView().getState(edgeCell);
            labelPoint.setX(edgeState.getLabelBounds().getX() + offsetX);
            labelPoint.setY(edgeState.getLabelBounds().getY());
            edgeLayout.setLabelPoint(labelPoint);
            List<mxPoint> absPoints = edgeState.getAbsolutePoints();
            List<mxPoint> edgePoints = edgeCell.getGeometry().getPoints();
            if (edgePoints == null) {
                edgePoints = new ArrayList<mxPoint>();
            }
            LayoutPointImpl startPoint = new LayoutPointImpl();
            startPoint.setX(absPoints.get(0).getX() + offsetX);
            startPoint.setY(absPoints.get(0).getY());
            LayoutPointImpl endPoint = new LayoutPointImpl();
            endPoint.setX(absPoints.get(absPoints.size() - 1).getX() + offsetX);
            endPoint.setY(absPoints.get(absPoints.size() - 1).getY());
            edgeLayout.setStartPoint(startPoint);
            edgeLayout.setEndPoint(endPoint);
            if (this.edgeLayoutCache.containsKey(edgeLayout.getId())) continue;
            edgeLayout.setLineType(LINE_TYPE_LINE);
            edgeLayout.getControlPoints().clear();
            if (edgePoints.size() > 0) {
                for (mxPoint point : edgePoints) {
                    LayoutPointImpl layoutPoint = new LayoutPointImpl();
                    layoutPoint.setX(point.getX() + offsetX);
                    layoutPoint.setY(point.getY());
                    edgeLayout.getControlPoints().add(layoutPoint);
                    edgeLayout.setLineType(LINE_TYPE_POLYLINE);
                }
            }
            this.edgeLayoutCache.put(edgeLayout.getId(), edgeLayout);
            this.createReturnNode(graph, parent, (mxCell)edgeCell.getTarget());
        }
    }

    private mxPoint getIntersection(mxPoint lineStart, mxPoint lineEnd, mxCell node) {
        mxPoint leftBoxEnd;
        mxPoint rightBoxEnd;
        mxPoint topBoxEnd;
        mxPoint bottomBoxEnd;
        mxGeometry nodeRect = node.getGeometry();
        mxPoint bottomBoxStart = new mxPoint(node.getGeometry().getX(), node.getGeometry().getY() + node.getGeometry().getHeight());
        mxPoint intersection = this.getXIntersection(lineStart, lineEnd, bottomBoxStart, bottomBoxEnd = new mxPoint(node.getGeometry().getX() + node.getGeometry().getWidth(), node.getGeometry().getY() + node.getGeometry().getHeight()));
        if (!Double.isNaN(intersection.getX()) && !Double.isNaN(intersection.getY()) && node.getGeometry().contains(intersection.getX(), intersection.getY()) && (nodeRect.contains(lineStart.getX(), lineStart.getY()) && lineStart.getY() < lineEnd.getY() && intersection.getY() > lineStart.getY() || nodeRect.contains(lineEnd.getX(), lineEnd.getY()) && lineStart.getY() > lineEnd.getY() && intersection.getY() > lineEnd.getY())) {
            return intersection;
        }
        mxPoint topBoxStart = new mxPoint(node.getGeometry().getX(), node.getGeometry().getY());
        intersection = this.getXIntersection(lineStart, lineEnd, topBoxStart, topBoxEnd = new mxPoint(node.getGeometry().getX() + node.getGeometry().getWidth(), node.getGeometry().getY()));
        if (!Double.isNaN(intersection.getX()) && !Double.isNaN(intersection.getY()) && node.getGeometry().contains(intersection.getX(), intersection.getY()) && (nodeRect.contains(lineStart.getX(), lineStart.getY()) && lineStart.getY() > lineEnd.getY() && intersection.getY() < lineStart.getY() || nodeRect.contains(lineEnd.getX(), lineEnd.getY()) && lineStart.getY() < lineEnd.getY() && intersection.getY() < lineEnd.getY())) {
            return intersection;
        }
        mxPoint rightBoxStart = new mxPoint(node.getGeometry().getX() + node.getGeometry().getWidth(), node.getGeometry().getY());
        intersection = this.getYIntersection(lineStart, lineEnd, rightBoxStart, rightBoxEnd = new mxPoint(node.getGeometry().getX() + node.getGeometry().getWidth(), node.getGeometry().getY() + node.getGeometry().getHeight()));
        if (!Double.isNaN(intersection.getX()) && !Double.isNaN(intersection.getY()) && node.getGeometry().contains(intersection.getX(), intersection.getY()) && (nodeRect.contains(lineStart.getX(), lineStart.getY()) && lineStart.getX() > lineEnd.getX() && intersection.getX() < lineStart.getX() || nodeRect.contains(lineEnd.getX(), lineEnd.getY()) && lineStart.getX() < lineEnd.getX() && intersection.getX() < lineEnd.getX())) {
            return intersection;
        }
        mxPoint leftBoxStart = new mxPoint(node.getGeometry().getX(), node.getGeometry().getY());
        intersection = this.getYIntersection(lineStart, lineEnd, leftBoxStart, leftBoxEnd = new mxPoint(node.getGeometry().getX(), node.getGeometry().getY() + node.getGeometry().getHeight()));
        if (!Double.isNaN(intersection.getX()) && !Double.isNaN(intersection.getY()) && node.getGeometry().contains(intersection.getX(), intersection.getY()) && (nodeRect.contains(lineStart.getX(), lineStart.getY()) && lineStart.getX() < lineEnd.getX() && intersection.getX() > lineStart.getX() || nodeRect.contains(lineEnd.getX(), lineEnd.getY()) && lineStart.getX() > lineEnd.getX() && intersection.getX() > lineEnd.getX())) {
            return intersection;
        }
        return new mxPoint(Double.NaN, Double.NaN);
    }

    private mxPoint getYIntersection(mxPoint lineStart, mxPoint lineEnd, mxPoint boxStart, mxPoint boxEnd) {
        double lineSlope = (lineEnd.getX() - lineStart.getX()) / (lineEnd.getY() - lineStart.getY());
        double boxSlope = (boxEnd.getX() - boxStart.getX()) / (boxEnd.getY() - boxStart.getY());
        double lineX = lineStart.getX() - lineSlope * lineStart.getY();
        double boxX = boxStart.getX() - boxSlope * boxStart.getY();
        double collisionY = (boxX - lineX) / (boxSlope - lineSlope);
        double newX = Math.floor(boxX);
        double newY = Double.isInfinite(lineSlope) ? lineStart.getY() : Math.floor(boxStart.getY() - (boxStart.getY() + collisionY));
        return new mxPoint(newX, newY);
    }

    private mxPoint getXIntersection(mxPoint lineStart, mxPoint lineEnd, mxPoint boxStart, mxPoint boxEnd) {
        double lineSlope = (lineEnd.getY() - lineStart.getY()) / (lineEnd.getX() - lineStart.getX());
        double boxSlope = (boxEnd.getY() - boxStart.getY()) / (boxEnd.getX() - boxStart.getX());
        double lineX = lineStart.getY() - lineSlope * lineStart.getX();
        double boxY = boxStart.getY() - boxSlope * boxStart.getX();
        double collisionX = (boxY - lineX) / (boxSlope - lineSlope);
        double newY = Math.floor(boxY);
        double newX = Double.isInfinite(lineSlope) ? lineStart.getX() : Math.floor(boxStart.getX() - (boxStart.getX() + collisionX));
        return new mxPoint(newX, newY);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.edgeLayoutCache.clear();
        this.jgraphEdgeCache.clear();
        this.jgraphVertexCache.clear();
        this.nodeLayoutCache.clear();
    }

    static {
        System.setProperty("java.awt.headless", "true");
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            UIManager.put("JTextField", MetalTextFieldUI.class.getName());
        }
        catch (Exception e) {
            log.error((Object)"Cannot load MetalLookAndFeel", (Throwable)e);
        }
    }
}

