/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxCurve;
import com.mxgraph.util.mxLine;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxCurveLabelShape
implements mxITextShape {
    protected String lastValue;
    protected Font lastFont;
    protected List<mxPoint> lastPoints;
    protected mxCurve curve;
    protected mxCellState state;
    protected LabelGlyphCache[] labelGlyphs;
    protected double labelSize;
    protected mxRectangle labelBounds;
    protected LabelPosition labelPosition = new LabelPosition();
    public static double LABEL_BUFFER = 30.0;
    public static double CURVE_TEXT_STRETCH_FACTOR = 20.0;
    public static mxRectangle INVALID_GLYPH_BOUNDS = new mxRectangle(0.0, 0.0, 0.0, 0.0);
    public int centerVisibleIndex = 0;
    public static Object FONT_FRACTIONALMETRICS = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
    public static FontRenderContext frc = new FontRenderContext(null, false, false);
    protected boolean rotationEnabled = true;

    public mxCurveLabelShape(mxCellState mxCellState2, mxCurve mxCurve2) {
        this.state = mxCellState2;
        this.curve = mxCurve2;
    }

    public boolean getRotationEnabled() {
        return this.rotationEnabled;
    }

    public void setRotationEnabled(boolean bl) {
        this.rotationEnabled = bl;
    }

    @Override
    public void paintShape(mxGraphics2DCanvas mxGraphics2DCanvas2, String string, mxCellState mxCellState2, Map<String, Object> map) {
        Rectangle rectangle = mxCellState2.getLabelBounds().getRectangle();
        Graphics2D graphics2D = mxGraphics2DCanvas2.getGraphics();
        if (this.labelGlyphs == null) {
            this.updateLabelBounds(string, map);
        }
        if (this.labelGlyphs != null && (graphics2D.getClipBounds() == null || graphics2D.getClipBounds().intersects(rectangle))) {
            float f = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f);
            Graphics2D graphics2D2 = graphics2D;
            graphics2D = mxGraphics2DCanvas2.createTemporaryGraphics(map, f, mxCellState2);
            Font font = mxUtils.getFont(map, mxGraphics2DCanvas2.getScale());
            graphics2D.setFont(font);
            Color color = mxUtils.getColor(map, mxConstants.STYLE_FONTCOLOR, Color.black);
            graphics2D.setColor(color);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, FONT_FRACTIONALMETRICS);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            for (int i = 0; i < string.length(); ++i) {
                mxLine mxLine2 = this.labelGlyphs[i].glyphVector;
                if (!this.labelGlyphs[i].visible || mxLine2 == null || mxLine2 == mxCurve.INVALID_POSITION) continue;
                mxPoint mxPoint2 = mxLine2.getEndPoint();
                double d = mxPoint2.getX();
                double d2 = Math.atan(mxPoint2.getY() / d);
                if (d < 0.0) {
                    d2 += Math.PI;
                }
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(mxLine2.getX(), mxLine2.getY());
                graphics2D.rotate(d2);
                GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string.substring(i, i + 1));
                Shape shape = glyphVector.getGlyphOutline(0);
                graphics2D.fill(shape);
                graphics2D.setTransform(affineTransform);
            }
            graphics2D.dispose();
            graphics2D = graphics2D2;
        }
    }

    public mxRectangle updateLabelBounds(String string, Map<String, Object> map) {
        double d = this.state.getView().getScale();
        Font font = mxUtils.getFont(map, d);
        FontMetrics fontMetrics = mxUtils.getFontMetrics(font);
        int n = 0;
        int n2 = 0;
        if (fontMetrics != null) {
            n = fontMetrics.getDescent();
            n2 = fontMetrics.getAscent();
        }
        if (this.labelGlyphs == null || string.length() != this.labelGlyphs.length) {
            this.labelGlyphs = new LabelGlyphCache[string.length()];
        }
        if (!string.equals(this.lastValue) || !font.equals(this.lastFont)) {
            this.labelSize = 0.0;
            for (int i = 0; i < string.length(); ++i) {
                String string2 = string.substring(i, i + 1);
                if (this.labelGlyphs[i] == null) {
                    this.labelGlyphs[i] = new LabelGlyphCache();
                }
                this.labelGlyphs[i].glyph = string2;
                if (fontMetrics == null) {
                    mxRectangle mxRectangle2;
                    this.labelGlyphs[i].labelGlyphBounds = mxRectangle2 = new mxRectangle(font.getStringBounds(string2, frc));
                    this.labelSize += mxRectangle2.getWidth();
                    continue;
                }
                double d2 = fontMetrics.stringWidth(string2);
                this.labelGlyphs[i].labelGlyphBounds = new mxRectangle(0.0, 0.0, d2, n2);
                this.labelSize += d2;
            }
            this.lastValue = string;
            this.lastFont = font;
            this.lastPoints = this.curve.getGuidePoints();
        }
        this.labelPosition.startBuffer = LABEL_BUFFER * d;
        this.labelPosition.endBuffer = LABEL_BUFFER * d;
        this.calculationLabelPosition(map, string);
        if (this.curve.isLabelReversed()) {
            double d3 = this.labelPosition.startBuffer;
            this.labelPosition.startBuffer = this.labelPosition.endBuffer;
            this.labelPosition.endBuffer = d3;
        }
        double d4 = this.curve.getCurveLength(mxCurve.LABEL_CURVE);
        double d5 = this.labelPosition.startBuffer / d4;
        double d6 = 1.0 - this.labelPosition.endBuffer / d4;
        mxRectangle mxRectangle3 = null;
        this.centerVisibleIndex = 0;
        double d7 = 0.0;
        double d8 = 0.3;
        double d9 = 0.5;
        mxLine mxLine2 = null;
        for (int i = 0; i < string.length(); ++i) {
            int n3;
            double d10;
            double d11;
            if (d5 > d6) {
                this.labelGlyphs[i].visible = false;
                continue;
            }
            mxLine mxLine3 = mxLine2;
            if (d7 > d8 || mxLine2 == null) {
                mxLine3 = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, d5);
                d7 = 0.0;
                mxLine2 = null;
            }
            this.labelGlyphs[i].glyphVector = mxLine3;
            if (mxLine3 == mxCurve.INVALID_POSITION) continue;
            double d12 = this.labelGlyphs[i].labelGlyphBounds.getWidth();
            double d13 = this.labelGlyphs[i].labelGlyphBounds.getHeight();
            double d14 = mxLine3.getEndPoint().getX();
            double d15 = mxLine3.getEndPoint().getY();
            double d16 = d11 = mxLine3.getX() - (double)n * d15;
            double d17 = d11;
            double d18 = d10 = mxLine3.getY() + (double)n * d14;
            double d19 = d10;
            double d20 = d11 + (d13 + (double)n) * d15;
            double d21 = d10 - (d13 + (double)n) * d14;
            d16 = Math.min(d16, d20);
            d17 = Math.max(d17, d20);
            d18 = Math.min(d18, d21);
            d19 = Math.max(d19, d21);
            double d22 = d11 + d12 * d14;
            double d23 = d10 + d12 * d15;
            d16 = Math.min(d16, d22);
            d17 = Math.max(d17, d22);
            d18 = Math.min(d18, d23);
            d19 = Math.max(d19, d23);
            double d24 = d20 + d12 * d14;
            double d25 = d21 + d12 * d15;
            d16 = Math.min(d16, d24);
            d17 = Math.max(d17, d24);
            d18 = Math.min(d18, d25);
            d19 = Math.max(d19, d25);
            d16 -= 2.0 * d;
            d18 -= 2.0 * d;
            d17 += 2.0 * d;
            d19 += 2.0 * d;
            this.postprocessGlyph(this.curve, i, d5);
            double d26 = d5 + (this.labelGlyphs[i].labelGlyphBounds.getWidth() + this.labelPosition.defaultInterGlyphSpace) / d4;
            mxLine2 = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, d26);
            d5 = d26;
            mxPoint mxPoint2 = mxLine2.getEndPoint();
            double d27 = mxPoint2.getX();
            double d28 = mxPoint2.getY();
            if (mxLine2 != mxCurve.INVALID_POSITION && i + 1 < string.length()) {
                double d29 = Math.abs(d14 - d27);
                double d30 = Math.abs(d15 - d28);
                d7 = Math.sqrt(d29 * d29 + d30 * d30);
            }
            if (d7 > d8 && (n3 = Line2D.relativeCCW(0.0, 0.0, d14, d15, d27, d28)) == 1) {
                if (d7 > d9) {
                    d7 = d9;
                }
                double d31 = d7 * CURVE_TEXT_STRETCH_FACTOR / d4;
                d5 += d31;
                d6 += d31;
            }
            if (this.labelGlyphs[i].drawingBounds != null) {
                this.labelGlyphs[i].drawingBounds.setRect(d16, d18, d17 - d16, d19 - d18);
            } else {
                this.labelGlyphs[i].drawingBounds = new mxRectangle(d16, d18, d17 - d16, d19 - d18);
            }
            if (mxRectangle3 == null) {
                mxRectangle3 = (mxRectangle)this.labelGlyphs[i].drawingBounds.clone();
            } else {
                mxRectangle3.add(this.labelGlyphs[i].drawingBounds);
            }
            this.labelGlyphs[i].visible = true;
            ++this.centerVisibleIndex;
        }
        this.centerVisibleIndex /= 2;
        if (mxRectangle3 == null) {
            mxLine mxLine4 = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, 0.5);
            mxRectangle3 = new mxRectangle(mxLine4.getX(), mxLine4.getY(), 1.0, 1.0);
        }
        this.labelBounds = mxRectangle3;
        return mxRectangle3;
    }

    protected void postprocessGlyph(mxCurve mxCurve2, int n, double d) {
    }

    public boolean intersectsRect(Rectangle rectangle) {
        if (this.labelBounds != null && !this.labelBounds.getRectangle().intersects(rectangle)) {
            return false;
        }
        for (int i = 0; i < this.labelGlyphs.length; ++i) {
            if (!this.labelGlyphs[i].visible || !rectangle.intersects(this.labelGlyphs[i].drawingBounds.getRectangle())) continue;
            return true;
        }
        return false;
    }

    protected void calculationLabelPosition(Map<String, Object> map, String string) {
        double d = this.curve.getCurveLength(mxCurve.LABEL_CURVE);
        double d2 = d - this.labelPosition.startBuffer - this.labelPosition.endBuffer;
        this.labelPosition.startBuffer = Math.max(this.labelPosition.startBuffer, this.labelPosition.startBuffer + d2 / 2.0 - this.labelSize / 2.0);
        this.labelPosition.endBuffer = Math.max(this.labelPosition.endBuffer, this.labelPosition.endBuffer + d2 / 2.0 - this.labelSize / 2.0);
    }

    public mxCurve getCurve() {
        return this.curve;
    }

    public void setCurve(mxCurve mxCurve2) {
        this.curve = mxCurve2;
    }

    public mxRectangle getLabelBounds() {
        return this.labelBounds;
    }

    public mxRectangle getCenterVisiblePosition() {
        return this.labelGlyphs[this.centerVisibleIndex].drawingBounds;
    }

    public class LabelPosition {
        public double startBuffer = LABEL_BUFFER;
        public double endBuffer = LABEL_BUFFER;
        public double defaultInterGlyphSpace = 0.0;
    }

    public class LabelGlyphCache {
        public mxRectangle labelGlyphBounds;
        public mxRectangle drawingBounds;
        public String glyph;
        public mxLine glyphVector;
        public boolean visible;
    }
}

